/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.java.checks;

import com.google.re2j.Pattern;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@Rule(key="EC5")
@DeprecatedRuleKey(repositoryKey="greencodeinitiative-java", ruleKey="SDMLQ1")
public class AvoidStatementForDMLQueries
extends IssuableSubscriptionVisitor {
    protected static final String MESSAGERULE = "You must not use Statement for a DML query";
    private static final Pattern PATTERN = Pattern.compile("(SELECT|INSERT INTO|UPDATE|DELETE FROM)\\s?.*", 1);
    private final MethodMatchers EXECUTE_METHOD = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofSubTypes(new String[]{"java.sql.Statement"}).names(new String[]{"executeUpdate"}).withAnyParameters().build()});

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        LiteralTree literalTree;
        String str;
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
        if (!this.EXECUTE_METHOD.matches(methodInvocationTree)) {
            return;
        }
        Arguments arguments = methodInvocationTree.arguments();
        if (arguments.size() < 1) {
            return;
        }
        ExpressionTree first = (ExpressionTree)arguments.get(0);
        if (first.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && PATTERN.matcher(str = (literalTree = (LiteralTree)first).value()).find()) {
            this.reportIssue((Tree)literalTree, MESSAGERULE);
        }
    }
}

