/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.java.checks;

import fr.greencodeinitiative.java.checks.enums.ConstOrLiteralDeclare;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@Rule(key="EC78")
@DeprecatedRuleKey(repositoryKey="greencodeinitiative-java", ruleKey="S78")
public class AvoidSetConstantInBatchUpdate
extends IssuableSubscriptionVisitor {
    protected static final String MESSAGERULE = "Avoid setting constants in batch update";
    private final AvoidSetConstantInBatchUpdateVisitor visitorInFile = new AvoidSetConstantInBatchUpdateVisitor();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.FOR_EACH_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.DO_STATEMENT);
    }

    public void visitNode(Tree tree) {
        tree.accept((TreeVisitor)this.visitorInFile);
    }

    private static final boolean isConstant(Tree arg) {
        if (arg.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodInvocationTree m = (MethodInvocationTree)arg;
            return Stream.of(ConstOrLiteralDeclare.values()).anyMatch(o -> o.isLiteralDeclare(m));
        }
        if (arg.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree m = (MemberSelectExpressionTree)arg;
            return Stream.of(ConstOrLiteralDeclare.values()).anyMatch(o -> o.isPublicMember(m));
        }
        return ConstOrLiteralDeclare.isLiteral(arg);
    }

    private class AvoidSetConstantInBatchUpdateVisitor
    extends BaseTreeVisitor {
        private final MethodMatchers setters = MethodMatchers.create().ofSubTypes(new String[]{PreparedStatement.class.getName()}).names(new String[]{"setBoolean", "setByte", "setShort", "setInt", "setLong", "setFloat", "setDouble", "setBigDecimal", "setString"}).addParametersMatcher(args -> args.size() == 2 && ((Type)args.get(0)).isPrimitive(Type.Primitives.INT)).build();

        private AvoidSetConstantInBatchUpdateVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (this.setters.matches(tree) && AvoidSetConstantInBatchUpdate.isConstant((Tree)tree.arguments().get(1))) {
                AvoidSetConstantInBatchUpdate.this.reportIssue((Tree)tree, AvoidSetConstantInBatchUpdate.MESSAGERULE);
            } else {
                super.visitMethodInvocation(tree);
            }
        }
    }
}

