/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.java.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@Deprecated(forRemoval=true)
@Rule(key="EC63")
@DeprecatedRuleKey(repositoryKey="greencodeinitiative-java", ruleKey="S63")
public class UnnecessarilyAssignValuesToVariables
extends BaseTreeVisitor
implements JavaFileScanner {
    protected static final String MESSAGERULE1 = "The variable is declared but not really used";
    protected static final String MESSAGERULE2 = "Immediately throw this expression instead of assigning it to the temporary variable";
    protected static final String MESSAGERULE3 = "Immediately return this expression instead of assigning it to the temporary variable";
    private JavaFileScannerContext context;
    private String errorMessage;
    private final Map<String, VariableTree> variableList = new HashMap<String, VariableTree>();
    private static final Map<String, Collection<Integer>> linesWithIssuesByVariable = new HashMap<String, Collection<Integer>>();

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitBlock(BlockTree tree) {
        GetVariableVisitor getVariableVisitor = new GetVariableVisitor();
        CheckUseVariableVisitor checkVariable = new CheckUseVariableVisitor();
        super.visitBlock(tree);
        this.checkImmediatelyReturnedVariable(tree);
        tree.accept((TreeVisitor)getVariableVisitor);
        tree.accept((TreeVisitor)checkVariable);
        this.variableList.forEach(this::reportIfUnknow);
        this.variableList.clear();
    }

    private void reportIfUnknow(String name, Tree tree) {
        Integer issueLine = tree.firstToken().range().start().line();
        if (!linesWithIssuesByVariable.containsKey(name) || !linesWithIssuesByVariable.get(name).contains(issueLine)) {
            if (!linesWithIssuesByVariable.containsKey(name)) {
                linesWithIssuesByVariable.put(name, new ArrayList());
            }
            linesWithIssuesByVariable.get(name).add(issueLine);
            this.context.reportIssue((JavaCheck)this, tree, MESSAGERULE1);
        }
    }

    private void checkImmediatelyReturnedVariable(BlockTree tree) {
        List statements = tree.body();
        int size = statements.size();
        if (size < 2) {
            return;
        }
        StatementTree butLastStatement = (StatementTree)statements.get(size - 2);
        if (butLastStatement.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            String identifier;
            VariableTree variableTree = (VariableTree)butLastStatement;
            if (!variableTree.modifiers().annotations().isEmpty()) {
                return;
            }
            StatementTree lastStatement = (StatementTree)statements.get(size - 1);
            String lastStatementIdentifier = this.getReturnOrThrowIdentifier(lastStatement);
            if (lastStatementIdentifier != null && lastStatementIdentifier.equals(identifier = variableTree.simpleName().name())) {
                this.context.reportIssue((JavaCheck)this, (Tree)variableTree.initializer(), this.errorMessage);
            }
        }
    }

    @CheckForNull
    private String getReturnOrThrowIdentifier(StatementTree lastStatementOfBlock) {
        this.errorMessage = null;
        ExpressionTree expr = null;
        if (lastStatementOfBlock.is(new Tree.Kind[]{Tree.Kind.THROW_STATEMENT})) {
            this.errorMessage = MESSAGERULE2;
            expr = ((ThrowStatementTree)lastStatementOfBlock).expression();
        } else if (lastStatementOfBlock.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            this.errorMessage = MESSAGERULE3;
            expr = ((ReturnStatementTree)lastStatementOfBlock).expression();
        }
        if (expr != null && expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)expr).name();
        }
        return null;
    }

    private class CheckUseVariableVisitor
    extends BaseTreeVisitor {
        private CheckUseVariableVisitor() {
        }

        public void visitIfStatement(IfStatementTree tree) {
            UnnecessarilyAssignValuesToVariables.this.variableList.remove(tree.condition().toString());
            super.visitIfStatement(tree);
        }

        public void visitUnaryExpression(UnaryExpressionTree tree) {
            UnnecessarilyAssignValuesToVariables.this.variableList.remove(tree.expression().toString());
            super.visitUnaryExpression(tree);
        }

        public void visitForEachStatement(ForEachStatement tree) {
            UnnecessarilyAssignValuesToVariables.this.variableList.remove(tree.expression().toString());
            super.visitForEachStatement(tree);
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            tree.arguments().forEach(e -> {
                if (UnnecessarilyAssignValuesToVariables.this.variableList.containsKey(e.toString())) {
                    UnnecessarilyAssignValuesToVariables.this.variableList.remove(e.toString());
                }
            });
            super.visitMethodInvocation(tree);
        }

        public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
            UnnecessarilyAssignValuesToVariables.this.variableList.remove(tree.expression().toString());
            super.visitMemberSelectExpression(tree);
        }

        public void visitTypeCast(TypeCastTree tree) {
            UnnecessarilyAssignValuesToVariables.this.variableList.remove(tree.expression().toString());
            super.visitTypeCast(tree);
        }

        public void visitBinaryExpression(BinaryExpressionTree tree) {
            if (!tree.operatorToken().is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
                UnnecessarilyAssignValuesToVariables.this.variableList.remove(tree.leftOperand().toString());
            }
            UnnecessarilyAssignValuesToVariables.this.variableList.remove(tree.rightOperand().toString());
            super.visitBinaryExpression(tree);
        }

        public void visitNewClass(NewClassTree tree) {
            tree.arguments().forEach(e -> {
                if (UnnecessarilyAssignValuesToVariables.this.variableList.containsKey(e.toString())) {
                    UnnecessarilyAssignValuesToVariables.this.variableList.remove(e.toString());
                }
            });
            super.visitNewClass(tree);
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            if (tree != null) {
                if (tree.expression() != null) {
                    UnnecessarilyAssignValuesToVariables.this.variableList.remove(tree.expression().toString());
                }
                super.visitReturnStatement(tree);
            }
        }

        public void visitThrowStatement(ThrowStatementTree tree) {
            UnnecessarilyAssignValuesToVariables.this.variableList.remove(tree.expression().toString());
            super.visitThrowStatement(tree);
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            UnnecessarilyAssignValuesToVariables.this.variableList.remove(tree.expression().toString());
            super.visitAssignmentExpression(tree);
        }
    }

    private class GetVariableVisitor
    extends BaseTreeVisitor {
        private GetVariableVisitor() {
        }

        public void visitVariable(VariableTree tree) {
            if (!tree.parent().is(new Tree.Kind[]{Tree.Kind.METHOD})) {
                UnnecessarilyAssignValuesToVariables.this.variableList.put(tree.simpleName().name(), tree);
            }
            super.visitVariable(tree);
        }
    }
}

