/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.python.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="EC66")
public class AvoidDoubleQuoteCheck
extends PythonSubscriptionCheck {
    public static final String MESSAGE_RULE = "Avoid using quotation mark (\"), prefer using simple quote (')";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.STRING_LITERAL, this::visitNodeString);
    }

    private void visitNodeString(SubscriptionContext subscriptionContext) {
        StringLiteral stringLiteral = (StringLiteral)subscriptionContext.syntaxNode();
        if (!stringLiteral.stringElements().isEmpty() && ((StringElement)stringLiteral.stringElements().get(0)).value().startsWith("\"")) {
            subscriptionContext.addIssue((Tree)stringLiteral, MESSAGE_RULE);
        }
    }
}

