/*
 * Decompiled with CFR 0.152.
 */
package fr.greencodeinitiative.python.checks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;

@Rule(key="EC203")
public class DetectUnoptimizedImageFormat
extends PythonSubscriptionCheck {
    protected static final String RULE_KEY = "EC203";
    protected static final String MESSAGERULE = "Detect unoptimized image format";
    protected static final String MESSAGEERROR = "If possible, the utilisation of svg image format (or <svg/> html tag) is recommended over other image format.";
    protected static final Pattern IMGEXTENSION = Pattern.compile("\\.(bmp|ico|tiff|webp|png|jpg|jpeg|jfif|pjpeg|pjp|gif|avif|apng)");

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.STRING_LITERAL, this::visitNodeString);
    }

    public void visitNodeString(SubscriptionContext ctx) {
        StringLiteral stringLiteral;
        String strValue;
        Matcher matcher;
        if (ctx.syntaxNode().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && (matcher = IMGEXTENSION.matcher(strValue = (stringLiteral = (StringLiteral)ctx.syntaxNode()).trimmedQuotesValue())).find()) {
            ctx.addIssue((Tree)stringLiteral, MESSAGEERROR);
        }
    }
}

