/*
 * Decompiled with CFR 0.152.
 */
package io.hypertrack.factory;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import io.hypertrack.model.HyperTrackModel;
import io.hypertrack.net.HyperTrackClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class HyperTrackFactory<T extends HyperTrackModel> {
    private HyperTrackClient client;

    protected HyperTrackFactory(HyperTrackClient client) {
        this.client = client;
    }

    protected abstract T makeNew(Map<String, Object> var1);

    protected abstract String getModelUrl();

    public T retrieve(String id) throws Exception {
        return this.getAndCreateFromId(id);
    }

    public T create(Map<String, Object> params) throws Exception {
        return this.postAndCreateFromParams(params);
    }

    public ArrayList<T> list(Map<String, Object> filters) throws Exception {
        return this.getListAndCreate(filters);
    }

    protected T getAndCreateFromId(String id) throws Exception {
        String response = this.client.request(this.getModelUrl() + id + "/", "GET", null);
        return this.createFromParams(HyperTrackFactory.getMapFromResponse(response));
    }

    protected T postAndCreateFromParams(Map<String, Object> params) throws Exception {
        String response = this.client.request(this.getModelUrl(), "POST", params);
        return this.createFromParams(HyperTrackFactory.getMapFromResponse(response));
    }

    protected ArrayList<T> getListAndCreate(Map<String, Object> filters) throws Exception {
        String response = this.client.request(this.getModelUrl(), "GET", filters);
        Gson gson = new Gson();
        Map<String, Object> responseMap = HyperTrackFactory.getMapFromResponse(response);
        ArrayList results = (ArrayList)responseMap.get("results");
        ArrayList<T> objectList = new ArrayList<T>();
        for (LinkedTreeMap temp : results) {
            HashMap<String, Object> params = new HashMap<String, Object>((Map<String, Object>)temp);
            objectList.add(this.createFromParams(params));
        }
        return objectList;
    }

    private T createFromParams(Map<String, Object> params) {
        return this.makeNew(params);
    }

    private static Map<String, Object> getMapFromResponse(String response) {
        Gson gson = new Gson();
        HashMap<String, Object> map = new HashMap();
        map = (Map)gson.fromJson(response, map.getClass());
        return map;
    }

    public HyperTrackClient getClient() {
        return this.client;
    }

    public void setClient(HyperTrackClient client) {
        this.client = client;
    }
}

