/*
 * Decompiled with CFR 0.152.
 */
package io.hypertrack.net;

import com.google.gson.Gson;
import io.hypertrack.net.HyperTrackException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HyperTrackClient {
    private String endpoint = "https://app.hypertrack.io/api/v1";
    private String VERSION = "0.1.2";
    private String userAgent = "HyperTrack/v1 JavaBindings/" + this.VERSION;
    private HttpClient httpClient;
    private String publishableKey;
    private String secretKey;

    public HyperTrackClient(String publishableKey, String secretKey) {
        this(publishableKey, secretKey, null);
    }

    public HyperTrackClient(String publishableKey, String secretKey, String endpoint) {
        this.publishableKey = publishableKey;
        this.secretKey = secretKey;
        if (endpoint != null) {
            this.endpoint = endpoint;
        }
        this.httpClient = HttpClients.createDefault();
    }

    public String request(String path, String method, Map<String, Object> data) throws Exception {
        Map<String, String> params = this.paramsToString(data);
        HttpUriRequest request = this.setupRequest(path, method, params);
        try {
            HttpResponse response = this.httpClient.execute(request);
            if (this.validateResponse(response)) {
                HttpEntity entity = response.getEntity();
                String responseBody = "";
                if (entity != null) {
                    responseBody = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
                return responseBody;
            }
            throw HyperTrackException.parseResponse(response);
        }
        catch (ClientProtocolException e1) {
            throw new ClientProtocolException((Throwable)e1);
        }
    }

    private HttpUriRequest setupRequest(String path, String method, Map<String, String> params) {
        String normalizedPath = path.toLowerCase();
        StringBuilder sb = new StringBuilder();
        if (normalizedPath.startsWith("http://") || normalizedPath.startsWith("https://")) {
            sb.append(path);
        } else {
            sb.append(this.endpoint);
            if (!normalizedPath.startsWith("/")) {
                sb.append("/");
            }
            sb.append(path);
        }
        path = sb.toString();
        HttpUriRequest request = this.buildMethod(path, method, params);
        request.addHeader((Header)new BasicHeader("Authorization", "token " + this.secretKey));
        request.addHeader((Header)new BasicHeader("User-Agent", this.userAgent));
        request.addHeader((Header)new BasicHeader("Accept", "application/json"));
        request.addHeader((Header)new BasicHeader("Content-Type", "application/json"));
        request.addHeader((Header)new BasicHeader("Accept-Charset", "utf-8"));
        return request;
    }

    private HttpUriRequest buildMethod(String path, String method, Map<String, String> params) {
        if (method.equalsIgnoreCase("GET")) {
            URI uri = this.buildUri(path, params);
            return new HttpGet(uri);
        }
        if (method.equalsIgnoreCase("POST")) {
            URI uri = this.buildUri(path, null);
            StringEntity entity = this.buildEntityBody(params);
            HttpPost post = new HttpPost(uri);
            post.setEntity((HttpEntity)entity);
            return post;
        }
        throw new IllegalArgumentException("Unknown HTTP method: " + method);
    }

    private URI buildUri(String path, Map<String, String> params) {
        URI uri;
        StringBuilder sb = new StringBuilder();
        sb.append(path);
        if (params != null && params.size() > 0) {
            sb.append("?");
            ArrayList<NameValuePair> paramsList = this.getListFromMap(params);
            sb.append(URLEncodedUtils.format(paramsList, (String)"UTF-8"));
        }
        try {
            uri = new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid uri", e);
        }
        return uri;
    }

    private StringEntity buildEntityBody(Map<String, String> params) {
        Gson gson = new Gson();
        String paramsJson = gson.toJson(params);
        try {
            return new StringEntity(paramsJson.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Invalid parameters", e);
        }
    }

    private ArrayList<NameValuePair> getListFromMap(Map<String, String> params) {
        ArrayList<NameValuePair> paramsList = new ArrayList<NameValuePair>();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue());
            paramsList.add((NameValuePair)pair);
        }
        return paramsList;
    }

    private Map<String, String> paramsToString(Map<String, Object> params) {
        if (params != null) {
            HashMap<String, String> paramsInString = new HashMap<String, String>();
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                paramsInString.put(entry.getKey(), entry.getValue().toString());
            }
            return paramsInString;
        }
        return null;
    }

    private boolean validateResponse(HttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        return statusCode >= 200 && statusCode < 300;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

