/*
 * Decompiled with CFR 0.152.
 */
package io.hypertrack.net;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class HyperTrackException
extends Exception {
    private int statusCode;
    private String message;

    public HyperTrackException(String message, int statusCode) {
        super(message);
        this.message = message;
        this.statusCode = statusCode;
    }

    public static HyperTrackException parseResponse(HttpResponse response) throws IOException {
        try {
            int responseCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            return new HyperTrackException(responseString, responseCode);
        }
        catch (IOException e) {
            throw new IOException("Unable to decode response");
        }
    }
}

