/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.admins.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConfigureAwayAdminRequest {
    private final String adminId;
    private final boolean awayModeEnabled;
    private final boolean awayModeReassign;
    private final Map<String, Object> additionalProperties;

    private ConfigureAwayAdminRequest(String adminId, boolean awayModeEnabled, boolean awayModeReassign, Map<String, Object> additionalProperties) {
        this.adminId = adminId;
        this.awayModeEnabled = awayModeEnabled;
        this.awayModeReassign = awayModeReassign;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="admin_id")
    public String getAdminId() {
        return this.adminId;
    }

    @JsonProperty(value="away_mode_enabled")
    public boolean getAwayModeEnabled() {
        return this.awayModeEnabled;
    }

    @JsonProperty(value="away_mode_reassign")
    public boolean getAwayModeReassign() {
        return this.awayModeReassign;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConfigureAwayAdminRequest && this.equalTo((ConfigureAwayAdminRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConfigureAwayAdminRequest other) {
        return this.adminId.equals(other.adminId) && this.awayModeEnabled == other.awayModeEnabled && this.awayModeReassign == other.awayModeReassign;
    }

    public int hashCode() {
        return Objects.hash(this.adminId, this.awayModeEnabled, this.awayModeReassign);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AdminIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AdminIdStage,
    AwayModeEnabledStage,
    AwayModeReassignStage,
    _FinalStage {
        private String adminId;
        private boolean awayModeEnabled;
        private boolean awayModeReassign;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ConfigureAwayAdminRequest other) {
            this.adminId(other.getAdminId());
            this.awayModeEnabled(other.getAwayModeEnabled());
            this.awayModeReassign(other.getAwayModeReassign());
            return this;
        }

        @Override
        @JsonSetter(value="admin_id")
        public AwayModeEnabledStage adminId(@NotNull String adminId) {
            this.adminId = Objects.requireNonNull(adminId, "adminId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="away_mode_enabled")
        public AwayModeReassignStage awayModeEnabled(boolean awayModeEnabled) {
            this.awayModeEnabled = awayModeEnabled;
            return this;
        }

        @Override
        @JsonSetter(value="away_mode_reassign")
        public _FinalStage awayModeReassign(boolean awayModeReassign) {
            this.awayModeReassign = awayModeReassign;
            return this;
        }

        @Override
        public ConfigureAwayAdminRequest build() {
            return new ConfigureAwayAdminRequest(this.adminId, this.awayModeEnabled, this.awayModeReassign, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ConfigureAwayAdminRequest build();
    }

    public static interface AwayModeReassignStage {
        public _FinalStage awayModeReassign(boolean var1);
    }

    public static interface AwayModeEnabledStage {
        public AwayModeReassignStage awayModeEnabled(boolean var1);
    }

    public static interface AdminIdStage {
        public AwayModeEnabledStage adminId(@NotNull String var1);

        public Builder from(ConfigureAwayAdminRequest var1);
    }
}

