/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.aiagent.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.ContentSourcesList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class AiAgent {
    private final SourceType sourceType;
    private final Optional<String> sourceTitle;
    private final Optional<String> lastAnswerType;
    private final Optional<String> resolutionState;
    private final Optional<Integer> rating;
    private final Optional<String> ratingRemark;
    private final Optional<ContentSourcesList> contentSources;
    private final Map<String, Object> additionalProperties;

    private AiAgent(SourceType sourceType, Optional<String> sourceTitle, Optional<String> lastAnswerType, Optional<String> resolutionState, Optional<Integer> rating, Optional<String> ratingRemark, Optional<ContentSourcesList> contentSources, Map<String, Object> additionalProperties) {
        this.sourceType = sourceType;
        this.sourceTitle = sourceTitle;
        this.lastAnswerType = lastAnswerType;
        this.resolutionState = resolutionState;
        this.rating = rating;
        this.ratingRemark = ratingRemark;
        this.contentSources = contentSources;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="source_type")
    public SourceType getSourceType() {
        return this.sourceType;
    }

    @JsonProperty(value="source_title")
    public Optional<String> getSourceTitle() {
        return this.sourceTitle;
    }

    @JsonProperty(value="last_answer_type")
    public Optional<String> getLastAnswerType() {
        return this.lastAnswerType;
    }

    @JsonProperty(value="resolution_state")
    public Optional<String> getResolutionState() {
        return this.resolutionState;
    }

    @JsonProperty(value="rating")
    public Optional<Integer> getRating() {
        return this.rating;
    }

    @JsonProperty(value="rating_remark")
    public Optional<String> getRatingRemark() {
        return this.ratingRemark;
    }

    @JsonProperty(value="content_sources")
    public Optional<ContentSourcesList> getContentSources() {
        return this.contentSources;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AiAgent && this.equalTo((AiAgent)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AiAgent other) {
        return this.sourceType.equals(other.sourceType) && this.sourceTitle.equals(other.sourceTitle) && this.lastAnswerType.equals(other.lastAnswerType) && this.resolutionState.equals(other.resolutionState) && this.rating.equals(other.rating) && this.ratingRemark.equals(other.ratingRemark) && this.contentSources.equals(other.contentSources);
    }

    public int hashCode() {
        return Objects.hash(this.sourceType, this.sourceTitle, this.lastAnswerType, this.resolutionState, this.rating, this.ratingRemark, this.contentSources);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SourceTypeStage builder() {
        return new Builder();
    }

    public static final class SourceType {
        public static final SourceType WORKFLOW = new SourceType(Value.WORKFLOW, "workflow");
        public static final SourceType WORKFLOW_PREVIEW = new SourceType(Value.WORKFLOW_PREVIEW, "workflow_preview");
        public static final SourceType FIN_PREVIEW = new SourceType(Value.FIN_PREVIEW, "fin_preview");
        public static final SourceType ESSENTIALS_PLAN_SETUP = new SourceType(Value.ESSENTIALS_PLAN_SETUP, "essentials_plan_setup");
        public static final SourceType PROFILE = new SourceType(Value.PROFILE, "profile");
        private final Value value;
        private final String string;

        SourceType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof SourceType && this.string.equals(((SourceType)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case WORKFLOW: {
                    return visitor.visitWorkflow();
                }
                case WORKFLOW_PREVIEW: {
                    return visitor.visitWorkflowPreview();
                }
                case FIN_PREVIEW: {
                    return visitor.visitFinPreview();
                }
                case ESSENTIALS_PLAN_SETUP: {
                    return visitor.visitEssentialsPlanSetup();
                }
                case PROFILE: {
                    return visitor.visitProfile();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static SourceType valueOf(String value) {
            switch (value) {
                case "workflow": {
                    return WORKFLOW;
                }
                case "workflow_preview": {
                    return WORKFLOW_PREVIEW;
                }
                case "fin_preview": {
                    return FIN_PREVIEW;
                }
                case "essentials_plan_setup": {
                    return ESSENTIALS_PLAN_SETUP;
                }
                case "profile": {
                    return PROFILE;
                }
            }
            return new SourceType(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitEssentialsPlanSetup();

            public T visitProfile();

            public T visitWorkflow();

            public T visitWorkflowPreview();

            public T visitFinPreview();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            ESSENTIALS_PLAN_SETUP,
            PROFILE,
            WORKFLOW,
            WORKFLOW_PREVIEW,
            FIN_PREVIEW,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements SourceTypeStage,
    _FinalStage {
        private SourceType sourceType;
        private Optional<ContentSourcesList> contentSources = Optional.empty();
        private Optional<String> ratingRemark = Optional.empty();
        private Optional<Integer> rating = Optional.empty();
        private Optional<String> resolutionState = Optional.empty();
        private Optional<String> lastAnswerType = Optional.empty();
        private Optional<String> sourceTitle = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(AiAgent other) {
            this.sourceType(other.getSourceType());
            this.sourceTitle(other.getSourceTitle());
            this.lastAnswerType(other.getLastAnswerType());
            this.resolutionState(other.getResolutionState());
            this.rating(other.getRating());
            this.ratingRemark(other.getRatingRemark());
            this.contentSources(other.getContentSources());
            return this;
        }

        @Override
        @JsonSetter(value="source_type")
        public _FinalStage sourceType(@NotNull SourceType sourceType) {
            this.sourceType = Objects.requireNonNull(sourceType, "sourceType must not be null");
            return this;
        }

        @Override
        public _FinalStage contentSources(ContentSourcesList contentSources) {
            this.contentSources = Optional.ofNullable(contentSources);
            return this;
        }

        @Override
        @JsonSetter(value="content_sources", nulls=Nulls.SKIP)
        public _FinalStage contentSources(Optional<ContentSourcesList> contentSources) {
            this.contentSources = contentSources;
            return this;
        }

        @Override
        public _FinalStage ratingRemark(String ratingRemark) {
            this.ratingRemark = Optional.ofNullable(ratingRemark);
            return this;
        }

        @Override
        @JsonSetter(value="rating_remark", nulls=Nulls.SKIP)
        public _FinalStage ratingRemark(Optional<String> ratingRemark) {
            this.ratingRemark = ratingRemark;
            return this;
        }

        @Override
        public _FinalStage rating(Integer rating) {
            this.rating = Optional.ofNullable(rating);
            return this;
        }

        @Override
        @JsonSetter(value="rating", nulls=Nulls.SKIP)
        public _FinalStage rating(Optional<Integer> rating) {
            this.rating = rating;
            return this;
        }

        @Override
        public _FinalStage resolutionState(String resolutionState) {
            this.resolutionState = Optional.ofNullable(resolutionState);
            return this;
        }

        @Override
        @JsonSetter(value="resolution_state", nulls=Nulls.SKIP)
        public _FinalStage resolutionState(Optional<String> resolutionState) {
            this.resolutionState = resolutionState;
            return this;
        }

        @Override
        public _FinalStage lastAnswerType(String lastAnswerType) {
            this.lastAnswerType = Optional.ofNullable(lastAnswerType);
            return this;
        }

        @Override
        @JsonSetter(value="last_answer_type", nulls=Nulls.SKIP)
        public _FinalStage lastAnswerType(Optional<String> lastAnswerType) {
            this.lastAnswerType = lastAnswerType;
            return this;
        }

        @Override
        public _FinalStage sourceTitle(String sourceTitle) {
            this.sourceTitle = Optional.ofNullable(sourceTitle);
            return this;
        }

        @Override
        @JsonSetter(value="source_title", nulls=Nulls.SKIP)
        public _FinalStage sourceTitle(Optional<String> sourceTitle) {
            this.sourceTitle = sourceTitle;
            return this;
        }

        @Override
        public AiAgent build() {
            return new AiAgent(this.sourceType, this.sourceTitle, this.lastAnswerType, this.resolutionState, this.rating, this.ratingRemark, this.contentSources, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public AiAgent build();

        public _FinalStage sourceTitle(Optional<String> var1);

        public _FinalStage sourceTitle(String var1);

        public _FinalStage lastAnswerType(Optional<String> var1);

        public _FinalStage lastAnswerType(String var1);

        public _FinalStage resolutionState(Optional<String> var1);

        public _FinalStage resolutionState(String var1);

        public _FinalStage rating(Optional<Integer> var1);

        public _FinalStage rating(Integer var1);

        public _FinalStage ratingRemark(Optional<String> var1);

        public _FinalStage ratingRemark(String var1);

        public _FinalStage contentSources(Optional<ContentSourcesList> var1);

        public _FinalStage contentSources(ContentSourcesList var1);
    }

    public static interface SourceTypeStage {
        public _FinalStage sourceType(@NotNull SourceType var1);

        public Builder from(AiAgent var1);
    }
}

