/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateConversationRequest {
    private final String conversationId;
    private final Optional<String> displayAs;
    private final Optional<Boolean> read;
    private final Optional<Map<String, Object>> customAttributes;
    private final Map<String, Object> additionalProperties;

    private UpdateConversationRequest(String conversationId, Optional<String> displayAs, Optional<Boolean> read, Optional<Map<String, Object>> customAttributes, Map<String, Object> additionalProperties) {
        this.conversationId = conversationId;
        this.displayAs = displayAs;
        this.read = read;
        this.customAttributes = customAttributes;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="conversation_id")
    public String getConversationId() {
        return this.conversationId;
    }

    @JsonProperty(value="display_as")
    public Optional<String> getDisplayAs() {
        return this.displayAs;
    }

    @JsonProperty(value="read")
    public Optional<Boolean> getRead() {
        return this.read;
    }

    @JsonProperty(value="custom_attributes")
    public Optional<Map<String, Object>> getCustomAttributes() {
        return this.customAttributes;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateConversationRequest && this.equalTo((UpdateConversationRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateConversationRequest other) {
        return this.conversationId.equals(other.conversationId) && this.displayAs.equals(other.displayAs) && this.read.equals(other.read) && this.customAttributes.equals(other.customAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.conversationId, this.displayAs, this.read, this.customAttributes);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConversationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ConversationIdStage,
    _FinalStage {
        private String conversationId;
        private Optional<Map<String, Object>> customAttributes = Optional.empty();
        private Optional<Boolean> read = Optional.empty();
        private Optional<String> displayAs = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateConversationRequest other) {
            this.conversationId(other.getConversationId());
            this.displayAs(other.getDisplayAs());
            this.read(other.getRead());
            this.customAttributes(other.getCustomAttributes());
            return this;
        }

        @Override
        @JsonSetter(value="conversation_id")
        public _FinalStage conversationId(@NotNull String conversationId) {
            this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
            return this;
        }

        @Override
        public _FinalStage customAttributes(Map<String, Object> customAttributes) {
            this.customAttributes = Optional.ofNullable(customAttributes);
            return this;
        }

        @Override
        @JsonSetter(value="custom_attributes", nulls=Nulls.SKIP)
        public _FinalStage customAttributes(Optional<Map<String, Object>> customAttributes) {
            this.customAttributes = customAttributes;
            return this;
        }

        @Override
        public _FinalStage read(Boolean read) {
            this.read = Optional.ofNullable(read);
            return this;
        }

        @Override
        @JsonSetter(value="read", nulls=Nulls.SKIP)
        public _FinalStage read(Optional<Boolean> read) {
            this.read = read;
            return this;
        }

        @Override
        public _FinalStage displayAs(String displayAs) {
            this.displayAs = Optional.ofNullable(displayAs);
            return this;
        }

        @Override
        @JsonSetter(value="display_as", nulls=Nulls.SKIP)
        public _FinalStage displayAs(Optional<String> displayAs) {
            this.displayAs = displayAs;
            return this;
        }

        @Override
        public UpdateConversationRequest build() {
            return new UpdateConversationRequest(this.conversationId, this.displayAs, this.read, this.customAttributes, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateConversationRequest build();

        public _FinalStage displayAs(Optional<String> var1);

        public _FinalStage displayAs(String var1);

        public _FinalStage read(Optional<Boolean> var1);

        public _FinalStage read(Boolean var1);

        public _FinalStage customAttributes(Optional<Map<String, Object>> var1);

        public _FinalStage customAttributes(Map<String, Object> var1);
    }

    public static interface ConversationIdStage {
        public _FinalStage conversationId(@NotNull String var1);

        public Builder from(UpdateConversationRequest var1);
    }
}

