/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.segments;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.IntercomApiException;
import com.intercom.api.core.IntercomException;
import com.intercom.api.core.IntercomHttpResponse;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.core.QueryStringMapper;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.errors.UnauthorizedError;
import com.intercom.api.resources.segments.requests.FindSegmentRequest;
import com.intercom.api.resources.segments.requests.ListSegmentsRequest;
import com.intercom.api.resources.segments.types.Segment;
import com.intercom.api.types.Error;
import com.intercom.api.types.SegmentList;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawSegmentsClient {
    protected final ClientOptions clientOptions;

    public AsyncRawSegmentsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public CompletableFuture<IntercomHttpResponse<SegmentList>> list() {
        return this.list(ListSegmentsRequest.builder().build());
    }

    public CompletableFuture<IntercomHttpResponse<SegmentList>> list(ListSegmentsRequest request) {
        return this.list(request, null);
    }

    public CompletableFuture<IntercomHttpResponse<SegmentList>> list(ListSegmentsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("segments");
        if (request.getIncludeCount().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "include_count", request.getIncludeCount().get().toString(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<IntercomHttpResponse<SegmentList>> future = new CompletableFuture<IntercomHttpResponse<SegmentList>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new IntercomHttpResponse<SegmentList>((SegmentList)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), SegmentList.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    try {
                        if (response.code() == 401) {
                            future.completeExceptionally(new UnauthorizedError((Error)ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Error.class), response));
                            return;
                        }
                    }
                    catch (JsonProcessingException jsonProcessingException) {
                        // empty catch block
                    }
                    future.completeExceptionally(new IntercomApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<IntercomHttpResponse<Segment>> find(FindSegmentRequest request) {
        return this.find(request, null);
    }

    public CompletableFuture<IntercomHttpResponse<Segment>> find(FindSegmentRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("segments").addPathSegment(request.getSegmentId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<IntercomHttpResponse<Segment>> future = new CompletableFuture<IntercomHttpResponse<Segment>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            /*
             * Exception decompiling
             */
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK], 2[TRYBLOCK]], but top level block is 8[CASE]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new IntercomException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}

