/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.resources.tickets.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.PartAttachment;
import com.intercom.api.types.Reference;
import com.intercom.api.types.TicketPartAuthor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TicketPart {
    private final String id;
    private final String partType;
    private final Optional<String> body;
    private final Optional<PreviousTicketState> previousTicketState;
    private final TicketState ticketState;
    private final int createdAt;
    private final Optional<Integer> updatedAt;
    private final Optional<Reference> assignedTo;
    private final Optional<TicketPartAuthor> author;
    private final Optional<List<PartAttachment>> attachments;
    private final Optional<String> externalId;
    private final Optional<Boolean> redacted;
    private final Map<String, Object> additionalProperties;

    private TicketPart(String id, String partType, Optional<String> body, Optional<PreviousTicketState> previousTicketState, TicketState ticketState, int createdAt, Optional<Integer> updatedAt, Optional<Reference> assignedTo, Optional<TicketPartAuthor> author, Optional<List<PartAttachment>> attachments, Optional<String> externalId, Optional<Boolean> redacted, Map<String, Object> additionalProperties) {
        this.id = id;
        this.partType = partType;
        this.body = body;
        this.previousTicketState = previousTicketState;
        this.ticketState = ticketState;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.assignedTo = assignedTo;
        this.author = author;
        this.attachments = attachments;
        this.externalId = externalId;
        this.redacted = redacted;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "ticket_part";
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="part_type")
    public String getPartType() {
        return this.partType;
    }

    @JsonProperty(value="body")
    public Optional<String> getBody() {
        return this.body;
    }

    @JsonProperty(value="previous_ticket_state")
    public Optional<PreviousTicketState> getPreviousTicketState() {
        return this.previousTicketState;
    }

    @JsonProperty(value="ticket_state")
    public TicketState getTicketState() {
        return this.ticketState;
    }

    @JsonProperty(value="created_at")
    public int getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="updated_at")
    public Optional<Integer> getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="assigned_to")
    public Optional<Reference> getAssignedTo() {
        return this.assignedTo;
    }

    @JsonProperty(value="author")
    public Optional<TicketPartAuthor> getAuthor() {
        return this.author;
    }

    @JsonProperty(value="attachments")
    public Optional<List<PartAttachment>> getAttachments() {
        return this.attachments;
    }

    @JsonProperty(value="external_id")
    public Optional<String> getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="redacted")
    public Optional<Boolean> getRedacted() {
        return this.redacted;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TicketPart && this.equalTo((TicketPart)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketPart other) {
        return this.id.equals(other.id) && this.partType.equals(other.partType) && this.body.equals(other.body) && this.previousTicketState.equals(other.previousTicketState) && this.ticketState.equals(other.ticketState) && this.createdAt == other.createdAt && this.updatedAt.equals(other.updatedAt) && this.assignedTo.equals(other.assignedTo) && this.author.equals(other.author) && this.attachments.equals(other.attachments) && this.externalId.equals(other.externalId) && this.redacted.equals(other.redacted);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.partType, this.body, this.previousTicketState, this.ticketState, this.createdAt, this.updatedAt, this.assignedTo, this.author, this.attachments, this.externalId, this.redacted);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public static final class TicketState {
        public static final TicketState IN_PROGRESS = new TicketState(Value.IN_PROGRESS, "in_progress");
        public static final TicketState SUBMITTED = new TicketState(Value.SUBMITTED, "submitted");
        public static final TicketState RESOLVED = new TicketState(Value.RESOLVED, "resolved");
        public static final TicketState WAITING_ON_CUSTOMER = new TicketState(Value.WAITING_ON_CUSTOMER, "waiting_on_customer");
        private final Value value;
        private final String string;

        TicketState(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof TicketState && this.string.equals(((TicketState)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case IN_PROGRESS: {
                    return visitor.visitInProgress();
                }
                case SUBMITTED: {
                    return visitor.visitSubmitted();
                }
                case RESOLVED: {
                    return visitor.visitResolved();
                }
                case WAITING_ON_CUSTOMER: {
                    return visitor.visitWaitingOnCustomer();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static TicketState valueOf(String value) {
            switch (value) {
                case "in_progress": {
                    return IN_PROGRESS;
                }
                case "submitted": {
                    return SUBMITTED;
                }
                case "resolved": {
                    return RESOLVED;
                }
                case "waiting_on_customer": {
                    return WAITING_ON_CUSTOMER;
                }
            }
            return new TicketState(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitSubmitted();

            public T visitInProgress();

            public T visitWaitingOnCustomer();

            public T visitResolved();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            SUBMITTED,
            IN_PROGRESS,
            WAITING_ON_CUSTOMER,
            RESOLVED,
            UNKNOWN;

        }
    }

    public static final class PreviousTicketState {
        public static final PreviousTicketState IN_PROGRESS = new PreviousTicketState(Value.IN_PROGRESS, "in_progress");
        public static final PreviousTicketState SUBMITTED = new PreviousTicketState(Value.SUBMITTED, "submitted");
        public static final PreviousTicketState RESOLVED = new PreviousTicketState(Value.RESOLVED, "resolved");
        public static final PreviousTicketState WAITING_ON_CUSTOMER = new PreviousTicketState(Value.WAITING_ON_CUSTOMER, "waiting_on_customer");
        private final Value value;
        private final String string;

        PreviousTicketState(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return this.string;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof PreviousTicketState && this.string.equals(((PreviousTicketState)other).string);
        }

        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (this.value) {
                case IN_PROGRESS: {
                    return visitor.visitInProgress();
                }
                case SUBMITTED: {
                    return visitor.visitSubmitted();
                }
                case RESOLVED: {
                    return visitor.visitResolved();
                }
                case WAITING_ON_CUSTOMER: {
                    return visitor.visitWaitingOnCustomer();
                }
            }
            return visitor.visitUnknown(this.string);
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static PreviousTicketState valueOf(String value) {
            switch (value) {
                case "in_progress": {
                    return IN_PROGRESS;
                }
                case "submitted": {
                    return SUBMITTED;
                }
                case "resolved": {
                    return RESOLVED;
                }
                case "waiting_on_customer": {
                    return WAITING_ON_CUSTOMER;
                }
            }
            return new PreviousTicketState(Value.UNKNOWN, value);
        }

        public static interface Visitor<T> {
            public T visitSubmitted();

            public T visitInProgress();

            public T visitWaitingOnCustomer();

            public T visitResolved();

            public T visitUnknown(String var1);
        }

        public static enum Value {
            SUBMITTED,
            IN_PROGRESS,
            WAITING_ON_CUSTOMER,
            RESOLVED,
            UNKNOWN;

        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    PartTypeStage,
    TicketStateStage,
    CreatedAtStage,
    _FinalStage {
        private String id;
        private String partType;
        private TicketState ticketState;
        private int createdAt;
        private Optional<Boolean> redacted = Optional.empty();
        private Optional<String> externalId = Optional.empty();
        private Optional<List<PartAttachment>> attachments = Optional.empty();
        private Optional<TicketPartAuthor> author = Optional.empty();
        private Optional<Reference> assignedTo = Optional.empty();
        private Optional<Integer> updatedAt = Optional.empty();
        private Optional<PreviousTicketState> previousTicketState = Optional.empty();
        private Optional<String> body = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TicketPart other) {
            this.id(other.getId());
            this.partType(other.getPartType());
            this.body(other.getBody());
            this.previousTicketState(other.getPreviousTicketState());
            this.ticketState(other.getTicketState());
            this.createdAt(other.getCreatedAt());
            this.updatedAt(other.getUpdatedAt());
            this.assignedTo(other.getAssignedTo());
            this.author(other.getAuthor());
            this.attachments(other.getAttachments());
            this.externalId(other.getExternalId());
            this.redacted(other.getRedacted());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public PartTypeStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="part_type")
        public TicketStateStage partType(@NotNull String partType) {
            this.partType = Objects.requireNonNull(partType, "partType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="ticket_state")
        public CreatedAtStage ticketState(@NotNull TicketState ticketState) {
            this.ticketState = Objects.requireNonNull(ticketState, "ticketState must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public _FinalStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public _FinalStage redacted(Boolean redacted) {
            this.redacted = Optional.ofNullable(redacted);
            return this;
        }

        @Override
        @JsonSetter(value="redacted", nulls=Nulls.SKIP)
        public _FinalStage redacted(Optional<Boolean> redacted) {
            this.redacted = redacted;
            return this;
        }

        @Override
        public _FinalStage externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        @Override
        @JsonSetter(value="external_id", nulls=Nulls.SKIP)
        public _FinalStage externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        @Override
        public _FinalStage attachments(List<PartAttachment> attachments) {
            this.attachments = Optional.ofNullable(attachments);
            return this;
        }

        @Override
        @JsonSetter(value="attachments", nulls=Nulls.SKIP)
        public _FinalStage attachments(Optional<List<PartAttachment>> attachments) {
            this.attachments = attachments;
            return this;
        }

        @Override
        public _FinalStage author(TicketPartAuthor author) {
            this.author = Optional.ofNullable(author);
            return this;
        }

        @Override
        @JsonSetter(value="author", nulls=Nulls.SKIP)
        public _FinalStage author(Optional<TicketPartAuthor> author) {
            this.author = author;
            return this;
        }

        @Override
        public _FinalStage assignedTo(Reference assignedTo) {
            this.assignedTo = Optional.ofNullable(assignedTo);
            return this;
        }

        @Override
        @JsonSetter(value="assigned_to", nulls=Nulls.SKIP)
        public _FinalStage assignedTo(Optional<Reference> assignedTo) {
            this.assignedTo = assignedTo;
            return this;
        }

        @Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        @Override
        @JsonSetter(value="updated_at", nulls=Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public _FinalStage previousTicketState(PreviousTicketState previousTicketState) {
            this.previousTicketState = Optional.ofNullable(previousTicketState);
            return this;
        }

        @Override
        @JsonSetter(value="previous_ticket_state", nulls=Nulls.SKIP)
        public _FinalStage previousTicketState(Optional<PreviousTicketState> previousTicketState) {
            this.previousTicketState = previousTicketState;
            return this;
        }

        @Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        @Override
        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @Override
        public TicketPart build() {
            return new TicketPart(this.id, this.partType, this.body, this.previousTicketState, this.ticketState, this.createdAt, this.updatedAt, this.assignedTo, this.author, this.attachments, this.externalId, this.redacted, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TicketPart build();

        public _FinalStage body(Optional<String> var1);

        public _FinalStage body(String var1);

        public _FinalStage previousTicketState(Optional<PreviousTicketState> var1);

        public _FinalStage previousTicketState(PreviousTicketState var1);

        public _FinalStage updatedAt(Optional<Integer> var1);

        public _FinalStage updatedAt(Integer var1);

        public _FinalStage assignedTo(Optional<Reference> var1);

        public _FinalStage assignedTo(Reference var1);

        public _FinalStage author(Optional<TicketPartAuthor> var1);

        public _FinalStage author(TicketPartAuthor var1);

        public _FinalStage attachments(Optional<List<PartAttachment>> var1);

        public _FinalStage attachments(List<PartAttachment> var1);

        public _FinalStage externalId(Optional<String> var1);

        public _FinalStage externalId(String var1);

        public _FinalStage redacted(Optional<Boolean> var1);

        public _FinalStage redacted(Boolean var1);
    }

    public static interface CreatedAtStage {
        public _FinalStage createdAt(int var1);
    }

    public static interface TicketStateStage {
        public CreatedAtStage ticketState(@NotNull TicketState var1);
    }

    public static interface PartTypeStage {
        public TicketStateStage partType(@NotNull String var1);
    }

    public static interface IdStage {
        public PartTypeStage id(@NotNull String var1);

        public Builder from(TicketPart var1);
    }
}

