/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.ActivityLog;
import com.intercom.api.types.CursorPages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ActivityLogList {
    private final Optional<CursorPages> pages;
    private final List<ActivityLog> activityLogs;
    private final Map<String, Object> additionalProperties;

    private ActivityLogList(Optional<CursorPages> pages, List<ActivityLog> activityLogs, Map<String, Object> additionalProperties) {
        this.pages = pages;
        this.activityLogs = activityLogs;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "activity_log.list";
    }

    @JsonProperty(value="pages")
    public Optional<CursorPages> getPages() {
        return this.pages;
    }

    @JsonProperty(value="activity_logs")
    public List<ActivityLog> getActivityLogs() {
        return this.activityLogs;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ActivityLogList && this.equalTo((ActivityLogList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ActivityLogList other) {
        return this.pages.equals(other.pages) && this.activityLogs.equals(other.activityLogs);
    }

    public int hashCode() {
        return Objects.hash(this.pages, this.activityLogs);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<CursorPages> pages = Optional.empty();
        private List<ActivityLog> activityLogs = new ArrayList<ActivityLog>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ActivityLogList other) {
            this.pages(other.getPages());
            this.activityLogs(other.getActivityLogs());
            return this;
        }

        @JsonSetter(value="pages", nulls=Nulls.SKIP)
        public Builder pages(Optional<CursorPages> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(CursorPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        @JsonSetter(value="activity_logs", nulls=Nulls.SKIP)
        public Builder activityLogs(List<ActivityLog> activityLogs) {
            this.activityLogs.clear();
            this.activityLogs.addAll(activityLogs);
            return this;
        }

        public Builder addActivityLogs(ActivityLog activityLogs) {
            this.activityLogs.add(activityLogs);
            return this;
        }

        public Builder addAllActivityLogs(List<ActivityLog> activityLogs) {
            this.activityLogs.addAll(activityLogs);
            return this;
        }

        public ActivityLogList build() {
            return new ActivityLogList(this.pages, this.activityLogs, this.additionalProperties);
        }
    }
}

