/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.admins.types.Admin;
import com.intercom.api.types.CanvasObject;
import com.intercom.api.types.Context;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonDeserialize(using=Deserializer.class)
public final class ConfigureRequest {
    private final Object value;
    private final int type;

    private ConfigureRequest(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((Zero)this.value);
        }
        if (this.type == 1) {
            return visitor.visit((ComponentId)this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConfigureRequest && this.equalTo((ConfigureRequest)other);
    }

    private boolean equalTo(ConfigureRequest other) {
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public static ConfigureRequest of(Zero value) {
        return new ConfigureRequest(value, 0);
    }

    public static ConfigureRequest of(ComponentId value) {
        return new ConfigureRequest(value, 1);
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class ComponentId {
        private final String workspaceId;
        private final String workspaceRegion;
        private final String componentId;
        private final Admin admin;
        private final Context context;
        private final CanvasObject currentCanvas;
        private final Map<String, Object> inputValues;
        private final Map<String, Object> additionalProperties;

        private ComponentId(String workspaceId, String workspaceRegion, String componentId, Admin admin, Context context, CanvasObject currentCanvas, Map<String, Object> inputValues, Map<String, Object> additionalProperties) {
            this.workspaceId = workspaceId;
            this.workspaceRegion = workspaceRegion;
            this.componentId = componentId;
            this.admin = admin;
            this.context = context;
            this.currentCanvas = currentCanvas;
            this.inputValues = inputValues;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="workspace_id")
        public String getWorkspaceId() {
            return this.workspaceId;
        }

        @JsonProperty(value="workspace_region")
        public String getWorkspaceRegion() {
            return this.workspaceRegion;
        }

        @JsonProperty(value="component_id")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonProperty(value="admin")
        public Admin getAdmin() {
            return this.admin;
        }

        @JsonProperty(value="context")
        public Context getContext() {
            return this.context;
        }

        @JsonProperty(value="current_canvas")
        public CanvasObject getCurrentCanvas() {
            return this.currentCanvas;
        }

        @JsonProperty(value="input_values")
        public Map<String, Object> getInputValues() {
            return this.inputValues;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ComponentId && this.equalTo((ComponentId)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(ComponentId other) {
            return this.workspaceId.equals(other.workspaceId) && this.workspaceRegion.equals(other.workspaceRegion) && this.componentId.equals(other.componentId) && this.admin.equals(other.admin) && this.context.equals(other.context) && this.currentCanvas.equals(other.currentCanvas) && this.inputValues.equals(other.inputValues);
        }

        public int hashCode() {
            return Objects.hash(this.workspaceId, this.workspaceRegion, this.componentId, this.admin, this.context, this.currentCanvas, this.inputValues);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static WorkspaceIdStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements WorkspaceIdStage,
        WorkspaceRegionStage,
        ComponentIdStage,
        AdminStage,
        ContextStage,
        CurrentCanvasStage,
        _FinalStage {
            private String workspaceId;
            private String workspaceRegion;
            private String componentId;
            private Admin admin;
            private Context context;
            private CanvasObject currentCanvas;
            private Map<String, Object> inputValues = new LinkedHashMap<String, Object>();
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(ComponentId other) {
                this.workspaceId(other.getWorkspaceId());
                this.workspaceRegion(other.getWorkspaceRegion());
                this.componentId(other.getComponentId());
                this.admin(other.getAdmin());
                this.context(other.getContext());
                this.currentCanvas(other.getCurrentCanvas());
                this.inputValues(other.getInputValues());
                return this;
            }

            @Override
            @JsonSetter(value="workspace_id")
            public WorkspaceRegionStage workspaceId(@NotNull String workspaceId) {
                this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="workspace_region")
            public ComponentIdStage workspaceRegion(@NotNull String workspaceRegion) {
                this.workspaceRegion = Objects.requireNonNull(workspaceRegion, "workspaceRegion must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="component_id")
            public AdminStage componentId(@NotNull String componentId) {
                this.componentId = Objects.requireNonNull(componentId, "componentId must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="admin")
            public ContextStage admin(@NotNull Admin admin) {
                this.admin = Objects.requireNonNull(admin, "admin must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="context")
            public CurrentCanvasStage context(@NotNull Context context) {
                this.context = Objects.requireNonNull(context, "context must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="current_canvas")
            public _FinalStage currentCanvas(@NotNull CanvasObject currentCanvas) {
                this.currentCanvas = Objects.requireNonNull(currentCanvas, "currentCanvas must not be null");
                return this;
            }

            @Override
            public _FinalStage inputValues(String key, Object value) {
                this.inputValues.put(key, value);
                return this;
            }

            @Override
            public _FinalStage putAllInputValues(Map<String, Object> inputValues) {
                this.inputValues.putAll(inputValues);
                return this;
            }

            @Override
            @JsonSetter(value="input_values", nulls=Nulls.SKIP)
            public _FinalStage inputValues(Map<String, Object> inputValues) {
                this.inputValues.clear();
                this.inputValues.putAll(inputValues);
                return this;
            }

            @Override
            public ComponentId build() {
                return new ComponentId(this.workspaceId, this.workspaceRegion, this.componentId, this.admin, this.context, this.currentCanvas, this.inputValues, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public ComponentId build();

            public _FinalStage inputValues(Map<String, Object> var1);

            public _FinalStage putAllInputValues(Map<String, Object> var1);

            public _FinalStage inputValues(String var1, Object var2);
        }

        public static interface CurrentCanvasStage {
            public _FinalStage currentCanvas(@NotNull CanvasObject var1);
        }

        public static interface ContextStage {
            public CurrentCanvasStage context(@NotNull Context var1);
        }

        public static interface AdminStage {
            public ContextStage admin(@NotNull Admin var1);
        }

        public static interface ComponentIdStage {
            public AdminStage componentId(@NotNull String var1);
        }

        public static interface WorkspaceRegionStage {
            public ComponentIdStage workspaceRegion(@NotNull String var1);
        }

        public static interface WorkspaceIdStage {
            public WorkspaceRegionStage workspaceId(@NotNull String var1);

            public Builder from(ComponentId var1);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder=Builder.class)
    public static final class Zero {
        private final String workspaceId;
        private final Admin admin;
        private final Context context;
        private final Map<String, Object> additionalProperties;

        private Zero(String workspaceId, Admin admin, Context context, Map<String, Object> additionalProperties) {
            this.workspaceId = workspaceId;
            this.admin = admin;
            this.context = context;
            this.additionalProperties = additionalProperties;
        }

        @JsonProperty(value="workspace_id")
        public String getWorkspaceId() {
            return this.workspaceId;
        }

        @JsonProperty(value="admin")
        public Admin getAdmin() {
            return this.admin;
        }

        @JsonProperty(value="context")
        public Context getContext() {
            return this.context;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof Zero && this.equalTo((Zero)other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(Zero other) {
            return this.workspaceId.equals(other.workspaceId) && this.admin.equals(other.admin) && this.context.equals(other.context);
        }

        public int hashCode() {
            return Objects.hash(this.workspaceId, this.admin, this.context);
        }

        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static WorkspaceIdStage builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        public static final class Builder
        implements WorkspaceIdStage,
        AdminStage,
        ContextStage,
        _FinalStage {
            private String workspaceId;
            private Admin admin;
            private Context context;
            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<String, Object>();

            private Builder() {
            }

            @Override
            public Builder from(Zero other) {
                this.workspaceId(other.getWorkspaceId());
                this.admin(other.getAdmin());
                this.context(other.getContext());
                return this;
            }

            @Override
            @JsonSetter(value="workspace_id")
            public AdminStage workspaceId(@NotNull String workspaceId) {
                this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="admin")
            public ContextStage admin(@NotNull Admin admin) {
                this.admin = Objects.requireNonNull(admin, "admin must not be null");
                return this;
            }

            @Override
            @JsonSetter(value="context")
            public _FinalStage context(@NotNull Context context) {
                this.context = Objects.requireNonNull(context, "context must not be null");
                return this;
            }

            @Override
            public Zero build() {
                return new Zero(this.workspaceId, this.admin, this.context, this.additionalProperties);
            }
        }

        public static interface _FinalStage {
            public Zero build();
        }

        public static interface ContextStage {
            public _FinalStage context(@NotNull Context var1);
        }

        public static interface AdminStage {
            public ContextStage admin(@NotNull Admin var1);
        }

        public static interface WorkspaceIdStage {
            public AdminStage workspaceId(@NotNull String var1);

            public Builder from(Zero var1);
        }
    }

    static final class Deserializer
    extends StdDeserializer<ConfigureRequest> {
        Deserializer() {
            super(ConfigureRequest.class);
        }

        public ConfigureRequest deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return ConfigureRequest.of((Zero)ObjectMappers.JSON_MAPPER.convertValue(value, Zero.class));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return ConfigureRequest.of((ComponentId)ObjectMappers.JSON_MAPPER.convertValue(value, ComponentId.class));
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    throw new JsonParseException(p, "Failed to deserialize");
                }
            }
        }
    }

    public static interface Visitor<T> {
        public T visit(Zero var1);

        public T visit(ComponentId var1);
    }
}

