/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.companies.types.Company;
import com.intercom.api.types.PagesLink;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContactAttachedCompanies {
    private final List<Company> companies;
    private final int totalCount;
    private final Optional<PagesLink> pages;
    private final Map<String, Object> additionalProperties;

    private ContactAttachedCompanies(List<Company> companies, int totalCount, Optional<PagesLink> pages, Map<String, Object> additionalProperties) {
        this.companies = companies;
        this.totalCount = totalCount;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "list";
    }

    @JsonProperty(value="companies")
    public List<Company> getCompanies() {
        return this.companies;
    }

    @JsonProperty(value="total_count")
    public int getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="pages")
    public Optional<PagesLink> getPages() {
        return this.pages;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContactAttachedCompanies && this.equalTo((ContactAttachedCompanies)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContactAttachedCompanies other) {
        return this.companies.equals(other.companies) && this.totalCount == other.totalCount && this.pages.equals(other.pages);
    }

    public int hashCode() {
        return Objects.hash(this.companies, this.totalCount, this.pages);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TotalCountStage,
    _FinalStage {
        private int totalCount;
        private Optional<PagesLink> pages = Optional.empty();
        private List<Company> companies = new ArrayList<Company>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ContactAttachedCompanies other) {
            this.companies(other.getCompanies());
            this.totalCount(other.getTotalCount());
            this.pages(other.getPages());
            return this;
        }

        @Override
        @JsonSetter(value="total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public _FinalStage pages(PagesLink pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        @Override
        @JsonSetter(value="pages", nulls=Nulls.SKIP)
        public _FinalStage pages(Optional<PagesLink> pages) {
            this.pages = pages;
            return this;
        }

        @Override
        public _FinalStage addAllCompanies(List<Company> companies) {
            this.companies.addAll(companies);
            return this;
        }

        @Override
        public _FinalStage addCompanies(Company companies) {
            this.companies.add(companies);
            return this;
        }

        @Override
        @JsonSetter(value="companies", nulls=Nulls.SKIP)
        public _FinalStage companies(List<Company> companies) {
            this.companies.clear();
            this.companies.addAll(companies);
            return this;
        }

        @Override
        public ContactAttachedCompanies build() {
            return new ContactAttachedCompanies(this.companies, this.totalCount, this.pages, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ContactAttachedCompanies build();

        public _FinalStage companies(List<Company> var1);

        public _FinalStage addCompanies(Company var1);

        public _FinalStage addAllCompanies(List<Company> var1);

        public _FinalStage pages(Optional<PagesLink> var1);

        public _FinalStage pages(PagesLink var1);
    }

    public static interface TotalCountStage {
        public _FinalStage totalCount(int var1);

        public Builder from(ContactAttachedCompanies var1);
    }
}

