/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.IContactReplyBaseRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContactReplyTicketUserIdRequest
implements IContactReplyBaseRequest {
    private final String body;
    private final Optional<Integer> createdAt;
    private final Optional<List<String>> attachmentUrls;
    private final String userId;
    private final Map<String, Object> additionalProperties;

    private ContactReplyTicketUserIdRequest(String body, Optional<Integer> createdAt, Optional<List<String>> attachmentUrls, String userId, Map<String, Object> additionalProperties) {
        this.body = body;
        this.createdAt = createdAt;
        this.attachmentUrls = attachmentUrls;
        this.userId = userId;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="message_type")
    public String getMessageType() {
        return "comment";
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return "user";
    }

    @Override
    @JsonProperty(value="body")
    public String getBody() {
        return this.body;
    }

    @Override
    @JsonProperty(value="created_at")
    public Optional<Integer> getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="attachment_urls")
    public Optional<List<String>> getAttachmentUrls() {
        return this.attachmentUrls;
    }

    @JsonProperty(value="user_id")
    public String getUserId() {
        return this.userId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContactReplyTicketUserIdRequest && this.equalTo((ContactReplyTicketUserIdRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContactReplyTicketUserIdRequest other) {
        return this.body.equals(other.body) && this.createdAt.equals(other.createdAt) && this.attachmentUrls.equals(other.attachmentUrls) && this.userId.equals(other.userId);
    }

    public int hashCode() {
        return Objects.hash(this.body, this.createdAt, this.attachmentUrls, this.userId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BodyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BodyStage,
    UserIdStage,
    _FinalStage {
        private String body;
        private String userId;
        private Optional<List<String>> attachmentUrls = Optional.empty();
        private Optional<Integer> createdAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ContactReplyTicketUserIdRequest other) {
            this.body(other.getBody());
            this.createdAt(other.getCreatedAt());
            this.attachmentUrls(other.getAttachmentUrls());
            this.userId(other.getUserId());
            return this;
        }

        @Override
        @JsonSetter(value="body")
        public UserIdStage body(@NotNull String body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="user_id")
        public _FinalStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        @Override
        public _FinalStage attachmentUrls(List<String> attachmentUrls) {
            this.attachmentUrls = Optional.ofNullable(attachmentUrls);
            return this;
        }

        @Override
        @JsonSetter(value="attachment_urls", nulls=Nulls.SKIP)
        public _FinalStage attachmentUrls(Optional<List<String>> attachmentUrls) {
            this.attachmentUrls = attachmentUrls;
            return this;
        }

        @Override
        public _FinalStage createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        @Override
        @JsonSetter(value="created_at", nulls=Nulls.SKIP)
        public _FinalStage createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public ContactReplyTicketUserIdRequest build() {
            return new ContactReplyTicketUserIdRequest(this.body, this.createdAt, this.attachmentUrls, this.userId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ContactReplyTicketUserIdRequest build();

        public _FinalStage createdAt(Optional<Integer> var1);

        public _FinalStage createdAt(Integer var1);

        public _FinalStage attachmentUrls(Optional<List<String>> var1);

        public _FinalStage attachmentUrls(List<String> var1);
    }

    public static interface UserIdStage {
        public _FinalStage userId(@NotNull String var1);
    }

    public static interface BodyStage {
        public UserIdStage body(@NotNull String var1);

        public Builder from(ContactReplyTicketUserIdRequest var1);
    }
}

