/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.aicontentsource.types.ContentSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ContentSourcesList {
    private final int totalCount;
    private final List<ContentSource> contentSources;
    private final Map<String, Object> additionalProperties;

    private ContentSourcesList(int totalCount, List<ContentSource> contentSources, Map<String, Object> additionalProperties) {
        this.totalCount = totalCount;
        this.contentSources = contentSources;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "content_source.list";
    }

    @JsonProperty(value="total_count")
    public int getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="content_sources")
    public List<ContentSource> getContentSources() {
        return this.contentSources;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ContentSourcesList && this.equalTo((ContentSourcesList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContentSourcesList other) {
        return this.totalCount == other.totalCount && this.contentSources.equals(other.contentSources);
    }

    public int hashCode() {
        return Objects.hash(this.totalCount, this.contentSources);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TotalCountStage,
    _FinalStage {
        private int totalCount;
        private List<ContentSource> contentSources = new ArrayList<ContentSource>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ContentSourcesList other) {
            this.totalCount(other.getTotalCount());
            this.contentSources(other.getContentSources());
            return this;
        }

        @Override
        @JsonSetter(value="total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public _FinalStage addAllContentSources(List<ContentSource> contentSources) {
            this.contentSources.addAll(contentSources);
            return this;
        }

        @Override
        public _FinalStage addContentSources(ContentSource contentSources) {
            this.contentSources.add(contentSources);
            return this;
        }

        @Override
        @JsonSetter(value="content_sources", nulls=Nulls.SKIP)
        public _FinalStage contentSources(List<ContentSource> contentSources) {
            this.contentSources.clear();
            this.contentSources.addAll(contentSources);
            return this;
        }

        @Override
        public ContentSourcesList build() {
            return new ContentSourcesList(this.totalCount, this.contentSources, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ContentSourcesList build();

        public _FinalStage contentSources(List<ContentSource> var1);

        public _FinalStage addContentSources(ContentSource var1);

        public _FinalStage addAllContentSources(List<ContentSource> var1);
    }

    public static interface TotalCountStage {
        public _FinalStage totalCount(int var1);

        public Builder from(ContentSourcesList var1);
    }
}

