/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ConversationAttachmentFiles {
    private final String contentType;
    private final String data;
    private final String name;
    private final Map<String, Object> additionalProperties;

    private ConversationAttachmentFiles(String contentType, String data, String name, Map<String, Object> additionalProperties) {
        this.contentType = contentType;
        this.data = data;
        this.name = name;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="content_type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="data")
    public String getData() {
        return this.data;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ConversationAttachmentFiles && this.equalTo((ConversationAttachmentFiles)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationAttachmentFiles other) {
        return this.contentType.equals(other.contentType) && this.data.equals(other.data) && this.name.equals(other.name);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.data, this.name);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ContentTypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ContentTypeStage,
    DataStage,
    NameStage,
    _FinalStage {
        private String contentType;
        private String data;
        private String name;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ConversationAttachmentFiles other) {
            this.contentType(other.getContentType());
            this.data(other.getData());
            this.name(other.getName());
            return this;
        }

        @Override
        @JsonSetter(value="content_type")
        public DataStage contentType(@NotNull String contentType) {
            this.contentType = Objects.requireNonNull(contentType, "contentType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="data")
        public NameStage data(@NotNull String data) {
            this.data = Objects.requireNonNull(data, "data must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public ConversationAttachmentFiles build() {
            return new ConversationAttachmentFiles(this.contentType, this.data, this.name, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ConversationAttachmentFiles build();
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);
    }

    public static interface DataStage {
        public NameStage data(@NotNull String var1);
    }

    public static interface ContentTypeStage {
        public DataStage contentType(@NotNull String var1);

        public Builder from(ConversationAttachmentFiles var1);
    }
}

