/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.ActionComponent;
import com.intercom.api.types.IListItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListItem
implements IListItem {
    private final String id;
    private final String title;
    private final Optional<String> subtitle;
    private final Optional<String> tertiaryText;
    private final Optional<Boolean> roundedImage;
    private final Optional<Boolean> disabled;
    private final Optional<ActionComponent> action;
    private final Map<String, Object> additionalProperties;

    private ListItem(String id, String title, Optional<String> subtitle, Optional<String> tertiaryText, Optional<Boolean> roundedImage, Optional<Boolean> disabled, Optional<ActionComponent> action, Map<String, Object> additionalProperties) {
        this.id = id;
        this.title = title;
        this.subtitle = subtitle;
        this.tertiaryText = tertiaryText;
        this.roundedImage = roundedImage;
        this.disabled = disabled;
        this.action = action;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return "item";
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty(value="subtitle")
    public Optional<String> getSubtitle() {
        return this.subtitle;
    }

    @Override
    @JsonProperty(value="tertiary_text")
    public Optional<String> getTertiaryText() {
        return this.tertiaryText;
    }

    @Override
    @JsonProperty(value="rounded_image")
    public Optional<Boolean> getRoundedImage() {
        return this.roundedImage;
    }

    @Override
    @JsonProperty(value="disabled")
    public Optional<Boolean> getDisabled() {
        return this.disabled;
    }

    @Override
    @JsonProperty(value="action")
    public Optional<ActionComponent> getAction() {
        return this.action;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListItem && this.equalTo((ListItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListItem other) {
        return this.id.equals(other.id) && this.title.equals(other.title) && this.subtitle.equals(other.subtitle) && this.tertiaryText.equals(other.tertiaryText) && this.roundedImage.equals(other.roundedImage) && this.disabled.equals(other.disabled) && this.action.equals(other.action);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.subtitle, this.tertiaryText, this.roundedImage, this.disabled, this.action);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    TitleStage,
    _FinalStage {
        private String id;
        private String title;
        private Optional<ActionComponent> action = Optional.empty();
        private Optional<Boolean> disabled = Optional.empty();
        private Optional<Boolean> roundedImage = Optional.empty();
        private Optional<String> tertiaryText = Optional.empty();
        private Optional<String> subtitle = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ListItem other) {
            this.id(other.getId());
            this.title(other.getTitle());
            this.subtitle(other.getSubtitle());
            this.tertiaryText(other.getTertiaryText());
            this.roundedImage(other.getRoundedImage());
            this.disabled(other.getDisabled());
            this.action(other.getAction());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public TitleStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="title")
        public _FinalStage title(@NotNull String title) {
            this.title = Objects.requireNonNull(title, "title must not be null");
            return this;
        }

        @Override
        public _FinalStage action(ActionComponent action) {
            this.action = Optional.ofNullable(action);
            return this;
        }

        @Override
        @JsonSetter(value="action", nulls=Nulls.SKIP)
        public _FinalStage action(Optional<ActionComponent> action) {
            this.action = action;
            return this;
        }

        @Override
        public _FinalStage disabled(Boolean disabled) {
            this.disabled = Optional.ofNullable(disabled);
            return this;
        }

        @Override
        @JsonSetter(value="disabled", nulls=Nulls.SKIP)
        public _FinalStage disabled(Optional<Boolean> disabled) {
            this.disabled = disabled;
            return this;
        }

        @Override
        public _FinalStage roundedImage(Boolean roundedImage) {
            this.roundedImage = Optional.ofNullable(roundedImage);
            return this;
        }

        @Override
        @JsonSetter(value="rounded_image", nulls=Nulls.SKIP)
        public _FinalStage roundedImage(Optional<Boolean> roundedImage) {
            this.roundedImage = roundedImage;
            return this;
        }

        @Override
        public _FinalStage tertiaryText(String tertiaryText) {
            this.tertiaryText = Optional.ofNullable(tertiaryText);
            return this;
        }

        @Override
        @JsonSetter(value="tertiary_text", nulls=Nulls.SKIP)
        public _FinalStage tertiaryText(Optional<String> tertiaryText) {
            this.tertiaryText = tertiaryText;
            return this;
        }

        @Override
        public _FinalStage subtitle(String subtitle) {
            this.subtitle = Optional.ofNullable(subtitle);
            return this;
        }

        @Override
        @JsonSetter(value="subtitle", nulls=Nulls.SKIP)
        public _FinalStage subtitle(Optional<String> subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        @Override
        public ListItem build() {
            return new ListItem(this.id, this.title, this.subtitle, this.tertiaryText, this.roundedImage, this.disabled, this.action, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ListItem build();

        public _FinalStage subtitle(Optional<String> var1);

        public _FinalStage subtitle(String var1);

        public _FinalStage tertiaryText(Optional<String> var1);

        public _FinalStage tertiaryText(String var1);

        public _FinalStage roundedImage(Optional<Boolean> var1);

        public _FinalStage roundedImage(Boolean var1);

        public _FinalStage disabled(Optional<Boolean> var1);

        public _FinalStage disabled(Boolean var1);

        public _FinalStage action(Optional<ActionComponent> var1);

        public _FinalStage action(ActionComponent var1);
    }

    public static interface TitleStage {
        public _FinalStage title(@NotNull String var1);
    }

    public static interface IdStage {
        public TitleStage id(@NotNull String var1);

        public Builder from(ListItem var1);
    }
}

