/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.notes.types.Note;
import com.intercom.api.types.OffsetPages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class NoteList {
    private final List<Note> data;
    private final int totalCount;
    private final Optional<OffsetPages> pages;
    private final Map<String, Object> additionalProperties;

    private NoteList(List<Note> data, int totalCount, Optional<OffsetPages> pages, Map<String, Object> additionalProperties) {
        this.data = data;
        this.totalCount = totalCount;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "list";
    }

    @JsonProperty(value="data")
    public List<Note> getData() {
        return this.data;
    }

    @JsonProperty(value="total_count")
    public int getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="pages")
    public Optional<OffsetPages> getPages() {
        return this.pages;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof NoteList && this.equalTo((NoteList)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(NoteList other) {
        return this.data.equals(other.data) && this.totalCount == other.totalCount && this.pages.equals(other.pages);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.totalCount, this.pages);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TotalCountStage,
    _FinalStage {
        private int totalCount;
        private Optional<OffsetPages> pages = Optional.empty();
        private List<Note> data = new ArrayList<Note>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(NoteList other) {
            this.data(other.getData());
            this.totalCount(other.getTotalCount());
            this.pages(other.getPages());
            return this;
        }

        @Override
        @JsonSetter(value="total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @Override
        public _FinalStage pages(OffsetPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        @Override
        @JsonSetter(value="pages", nulls=Nulls.SKIP)
        public _FinalStage pages(Optional<OffsetPages> pages) {
            this.pages = pages;
            return this;
        }

        @Override
        public _FinalStage addAllData(List<Note> data) {
            this.data.addAll(data);
            return this;
        }

        @Override
        public _FinalStage addData(Note data) {
            this.data.add(data);
            return this;
        }

        @Override
        @JsonSetter(value="data", nulls=Nulls.SKIP)
        public _FinalStage data(List<Note> data) {
            this.data.clear();
            this.data.addAll(data);
            return this;
        }

        @Override
        public NoteList build() {
            return new NoteList(this.data, this.totalCount, this.pages, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public NoteList build();

        public _FinalStage data(List<Note> var1);

        public _FinalStage addData(Note var1);

        public _FinalStage addAllData(List<Note> var1);

        public _FinalStage pages(Optional<OffsetPages> var1);

        public _FinalStage pages(OffsetPages var1);
    }

    public static interface TotalCountStage {
        public _FinalStage totalCount(int var1);

        public Builder from(NoteList var1);
    }
}

