/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SocialProfile {
    private final String name;
    private final String url;
    private final Map<String, Object> additionalProperties;

    private SocialProfile(String name, String url, Map<String, Object> additionalProperties) {
        this.name = name;
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "social_profile";
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SocialProfile && this.equalTo((SocialProfile)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SocialProfile other) {
        return this.name.equals(other.name) && this.url.equals(other.url);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.url);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    UrlStage,
    _FinalStage {
        private String name;
        private String url;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SocialProfile other) {
            this.name(other.getName());
            this.url(other.getUrl());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public UrlStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public _FinalStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @Override
        public SocialProfile build() {
            return new SocialProfile(this.name, this.url, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SocialProfile build();
    }

    public static interface UrlStage {
        public _FinalStage url(@NotNull String var1);
    }

    public static interface NameStage {
        public UrlStage name(@NotNull String var1);

        public Builder from(SocialProfile var1);
    }
}

