/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class VisitorDeletedObject {
    private final String id;
    private final String userId;
    private final Map<String, Object> additionalProperties;

    private VisitorDeletedObject(String id, String userId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.userId = userId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "visitor";
    }

    @JsonProperty(value="user_id")
    public String getUserId() {
        return this.userId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof VisitorDeletedObject && this.equalTo((VisitorDeletedObject)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(VisitorDeletedObject other) {
        return this.id.equals(other.id) && this.userId.equals(other.userId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.userId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    UserIdStage,
    _FinalStage {
        private String id;
        private String userId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(VisitorDeletedObject other) {
            this.id(other.getId());
            this.userId(other.getUserId());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public UserIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="user_id")
        public _FinalStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        @Override
        public VisitorDeletedObject build() {
            return new VisitorDeletedObject(this.id, this.userId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public VisitorDeletedObject build();
    }

    public static interface UserIdStage {
        public _FinalStage userId(@NotNull String var1);
    }

    public static interface IdStage {
        public UserIdStage id(@NotNull String var1);

        public Builder from(VisitorDeletedObject var1);
    }
}

