/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.contacts;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.companies.types.Company;
import com.intercom.api.resources.contacts.requests.ArchiveContactRequest;
import com.intercom.api.resources.contacts.requests.AttachSubscriptionToContactRequest;
import com.intercom.api.resources.contacts.requests.DeleteContactRequest;
import com.intercom.api.resources.contacts.requests.DetachSubscriptionFromContactRequest;
import com.intercom.api.resources.contacts.requests.FindContactRequest;
import com.intercom.api.resources.contacts.requests.ListAttachedCompaniesRequest;
import com.intercom.api.resources.contacts.requests.ListAttachedSubscriptionsRequest;
import com.intercom.api.resources.contacts.requests.ListContactsRequest;
import com.intercom.api.resources.contacts.requests.ListSegmentsAttachedToContactRequest;
import com.intercom.api.resources.contacts.requests.ListTagsAttachedToContactRequest;
import com.intercom.api.resources.contacts.requests.MergeContactsRequest;
import com.intercom.api.resources.contacts.requests.UnarchiveContactRequest;
import com.intercom.api.resources.contacts.requests.UpdateContactRequest;
import com.intercom.api.resources.contacts.types.Contact;
import com.intercom.api.resources.subscriptiontypes.types.SubscriptionType;
import com.intercom.api.types.ContactArchived;
import com.intercom.api.types.ContactDeleted;
import com.intercom.api.types.ContactSegments;
import com.intercom.api.types.ContactUnarchived;
import com.intercom.api.types.CreateContactRequest;
import com.intercom.api.types.SearchRequest;
import com.intercom.api.types.SubscriptionTypeList;
import com.intercom.api.types.TagList;
import java.util.concurrent.CompletableFuture;

public class AsyncContactsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawContactsClient rawClient;

    public AsyncContactsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawContactsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawContactsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can fetch a list of companies that are associated to a contact.
     */
    public CompletableFuture<SyncPagingIterable<Company>> listAttachedCompanies(ListAttachedCompaniesRequest request) {
        return this.rawClient.listAttachedCompanies(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of companies that are associated to a contact.
     */
    public CompletableFuture<SyncPagingIterable<Company>> listAttachedCompanies(
            ListAttachedCompaniesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAttachedCompanies(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of segments that are associated to a contact.
     */
    public CompletableFuture<ContactSegments> listAttachedSegments(ListSegmentsAttachedToContactRequest request) {
        return this.rawClient.listAttachedSegments(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of segments that are associated to a contact.
     */
    public CompletableFuture<ContactSegments> listAttachedSegments(
            ListSegmentsAttachedToContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAttachedSegments(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of subscription types that are attached to a contact. These can be subscriptions that a user has 'opted-in' to or has 'opted-out' from, depending on the subscription type.
     * This will return a list of Subscription Type objects that the contact is associated with.
     * <p>The data property will show a combined list of:</p>
     * <p>1.Opt-out subscription types that the user has opted-out from.
     * 2.Opt-in subscription types that the user has opted-in to receiving.</p>
     */
    public CompletableFuture<SubscriptionTypeList> listAttachedSubscriptions(ListAttachedSubscriptionsRequest request) {
        return this.rawClient.listAttachedSubscriptions(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of subscription types that are attached to a contact. These can be subscriptions that a user has 'opted-in' to or has 'opted-out' from, depending on the subscription type.
     * This will return a list of Subscription Type objects that the contact is associated with.
     * <p>The data property will show a combined list of:</p>
     * <p>1.Opt-out subscription types that the user has opted-out from.
     * 2.Opt-in subscription types that the user has opted-in to receiving.</p>
     */
    public CompletableFuture<SubscriptionTypeList> listAttachedSubscriptions(
            ListAttachedSubscriptionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAttachedSubscriptions(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can add a specific subscription to a contact. In Intercom, we have two different subscription types based on user consent - opt-out and opt-in:
     * <p>1.Attaching a contact to an opt-out subscription type will opt that user out from receiving messages related to that subscription type.</p>
     * <p>2.Attaching a contact to an opt-in subscription type will opt that user in to receiving messages related to that subscription type.</p>
     * <p>This will return a subscription type model for the subscription type that was added to the contact.</p>
     */
    public CompletableFuture<SubscriptionType> attachSubscription(AttachSubscriptionToContactRequest request) {
        return this.rawClient.attachSubscription(request).thenApply(response -> response.body());
    }

    /**
     * You can add a specific subscription to a contact. In Intercom, we have two different subscription types based on user consent - opt-out and opt-in:
     * <p>1.Attaching a contact to an opt-out subscription type will opt that user out from receiving messages related to that subscription type.</p>
     * <p>2.Attaching a contact to an opt-in subscription type will opt that user in to receiving messages related to that subscription type.</p>
     * <p>This will return a subscription type model for the subscription type that was added to the contact.</p>
     */
    public CompletableFuture<SubscriptionType> attachSubscription(
            AttachSubscriptionToContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.attachSubscription(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can remove a specific subscription from a contact. This will return a subscription type model for the subscription type that was removed from the contact.
     */
    public CompletableFuture<SubscriptionType> detachSubscription(DetachSubscriptionFromContactRequest request) {
        return this.rawClient.detachSubscription(request).thenApply(response -> response.body());
    }

    /**
     * You can remove a specific subscription from a contact. This will return a subscription type model for the subscription type that was removed from the contact.
     */
    public CompletableFuture<SubscriptionType> detachSubscription(
            DetachSubscriptionFromContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.detachSubscription(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of all tags that are attached to a specific contact.
     */
    public CompletableFuture<TagList> listAttachedTags(ListTagsAttachedToContactRequest request) {
        return this.rawClient.listAttachedTags(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of all tags that are attached to a specific contact.
     */
    public CompletableFuture<TagList> listAttachedTags(
            ListTagsAttachedToContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.listAttachedTags(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single contact.
     */
    public CompletableFuture<Contact> find(FindContactRequest request) {
        return this.rawClient.find(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single contact.
     */
    public CompletableFuture<Contact> find(FindContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.find(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can update an existing contact (ie. user or lead).
     */
    public CompletableFuture<Contact> update(UpdateContactRequest request) {
        return this.rawClient.update(request).thenApply(response -> response.body());
    }

    /**
     * You can update an existing contact (ie. user or lead).
     */
    public CompletableFuture<Contact> update(UpdateContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can delete a single contact.
     */
    public CompletableFuture<ContactDeleted> delete(DeleteContactRequest request) {
        return this.rawClient.delete(request).thenApply(response -> response.body());
    }

    /**
     * You can delete a single contact.
     */
    public CompletableFuture<ContactDeleted> delete(DeleteContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can merge a contact with a <code>role</code> of <code>lead</code> into a contact with a <code>role</code> of <code>user</code>.
     */
    public CompletableFuture<Contact> mergeLeadInUser(MergeContactsRequest request) {
        return this.rawClient.mergeLeadInUser(request).thenApply(response -> response.body());
    }

    /**
     * You can merge a contact with a <code>role</code> of <code>lead</code> into a contact with a <code>role</code> of <code>user</code>.
     */
    public CompletableFuture<Contact> mergeLeadInUser(MergeContactsRequest request, RequestOptions requestOptions) {
        return this.rawClient.mergeLeadInUser(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can search for multiple contacts by the value of their attributes in order to fetch exactly who you want.
     * <p>To search for contacts, you need to send a <code>POST</code> request to <code>https://api.intercom.io/contacts/search</code>.</p>
     * <p>This will accept a query object in the body which will define your filters in order to search for contacts.</p>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Optimizing search queries&quot; %}
     * Search queries can be complex, so optimizing them can help the performance of your search.
     * Use the <code>AND</code> and <code>OR</code> operators to combine multiple filters to get the exact results you need and utilize
     * pagination to limit the number of results returned. The default is <code>50</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     * <h3>Contact Creation Delay</h3>
     * <p>If a contact has recently been created, there is a possibility that it will not yet be available when searching. This means that it may not appear in the response. This delay can take a few minutes. If you need to be instantly notified it is recommended to use webhooks and iterate to see if they match your search filters.</p>
     * <h3>Nesting &amp; Limitations</h3>
     * <p>You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
     * There are some limitations to the amount of multiple's there can be:</p>
     * <ul>
     * <li>There's a limit of max 2 nested filters</li>
     * <li>There's a limit of max 15 filters for each AND or OR group</li>
     * </ul>
     * <h3>Searching for Timestamp Fields</h3>
     * <p>All timestamp fields (created_at, updated_at etc.) are indexed as Dates for Contact Search queries; Datetime queries are not currently supported. This means you can only query for timestamp fields by day - not hour, minute or second.
     * For example, if you search for all Contacts with a created_at value greater (&gt;) than 1577869200 (the UNIX timestamp for January 1st, 2020 9:00 AM), that will be interpreted as 1577836800 (January 1st, 2020 12:00 AM). The search results will then include Contacts created from January 2nd, 2020 12:00 AM onwards.
     * If you'd like to get contacts created on January 1st, 2020 you should search with a created_at value equal (=) to 1577836800 (January 1st, 2020 12:00 AM).
     * This behaviour applies only to timestamps used in search queries. The search results will still contain the full UNIX timestamp and be sorted accordingly.</p>
     * <h3>Accepted Fields</h3>
     * <p>Most key listed as part of the Contacts Model are searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as <code>created_at</code> accepts a date, the <code>value</code> cannot be a string such as <code>&quot;foorbar&quot;</code>).</p>
     * <p>| Field                              | Type                           |
     * | ---------------------------------- | ------------------------------ |
     * | id                                 | String                         |
     * | role                               | String&lt;br&gt;Accepts user or lead |
     * | name                               | String                         |
     * | avatar                             | String                         |
     * | owner_id                           | Integer                        |
     * | email                              | String                         |
     * | email_domain                       | String                         |
     * | phone                              | String                         |
     * | external_id                        | String                         |
     * | created_at                         | Date (UNIX Timestamp)          |
     * | signed_up_at                       | Date (UNIX Timestamp)          |
     * | updated_at                         | Date (UNIX Timestamp)          |
     * | last_seen_at                       | Date (UNIX Timestamp)          |
     * | last_contacted_at                  | Date (UNIX Timestamp)          |
     * | last_replied_at                    | Date (UNIX Timestamp)          |
     * | last_email_opened_at               | Date (UNIX Timestamp)          |
     * | last_email_clicked_at              | Date (UNIX Timestamp)          |
     * | language_override                  | String                         |
     * | browser                            | String                         |
     * | browser_language                   | String                         |
     * | os                                 | String                         |
     * | location.country                   | String                         |
     * | location.region                    | String                         |
     * | location.city                      | String                         |
     * | unsubscribed_from_emails           | Boolean                        |
     * | marked_email_as_spam               | Boolean                        |
     * | has_hard_bounced                   | Boolean                        |
     * | ios_last_seen_at                   | Date (UNIX Timestamp)          |
     * | ios_app_version                    | String                         |
     * | ios_device                         | String                         |
     * | ios_app_device                     | String                         |
     * | ios_os_version                     | String                         |
     * | ios_app_name                       | String                         |
     * | ios_sdk_version                    | String                         |
     * | android_last_seen_at               | Date (UNIX Timestamp)          |
     * | android_app_version                | String                         |
     * | android_device                     | String                         |
     * | android_app_name                   | String                         |
     * | andoid_sdk_version                 | String                         |
     * | segment_id                         | String                         |
     * | tag_id                             | String                         |
     * | custom_attributes.{attribute_name} | String                         |</p>
     * <h3>Accepted Operators</h3>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Searching based on <code>created_at</code>&quot; %}
     * You cannot use the <code>&lt;=</code> or <code>&gt;=</code> operators to search by <code>created_at</code>.
     * {% /admonition %}</p>
     * <p>The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (<code>&quot;=&quot;</code>). The operator has to be compatible with the field's type (eg. you cannot search with <code>&gt;</code> for a given string value as it's only compatible for integer's and dates).</p>
     * <p>| Operator | Valid Types                      | Description                                                      |
     * | :------- | :------------------------------- | :--------------------------------------------------------------- |
     * | =        | All                              | Equals                                                           |
     * | !=       | All                              | Doesn't Equal                                                    |
     * | IN       | All                              | In&lt;br&gt;Shortcut for <code>OR</code> queries&lt;br&gt;Values must be in Array       |
     * | NIN      | All                              | Not In&lt;br&gt;Shortcut for <code>OR !</code> queries&lt;br&gt;Values must be in Array |
     * | &gt;        | Integer&lt;br&gt;Date (UNIX Timestamp) | Greater than                                                     |
     * | &lt;       | Integer&lt;br&gt;Date (UNIX Timestamp) | Lower than                                                       |
     * | ~        | String                           | Contains                                                         |
     * | !~       | String                           | Doesn't Contain                                                  |
     * | ^        | String                           | Starts With                                                      |
     * | $        | String                           | Ends With                                                        |</p>
     */
    public CompletableFuture<SyncPagingIterable<Contact>> search(SearchRequest request) {
        return this.rawClient.search(request).thenApply(response -> response.body());
    }

    /**
     * You can search for multiple contacts by the value of their attributes in order to fetch exactly who you want.
     * <p>To search for contacts, you need to send a <code>POST</code> request to <code>https://api.intercom.io/contacts/search</code>.</p>
     * <p>This will accept a query object in the body which will define your filters in order to search for contacts.</p>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Optimizing search queries&quot; %}
     * Search queries can be complex, so optimizing them can help the performance of your search.
     * Use the <code>AND</code> and <code>OR</code> operators to combine multiple filters to get the exact results you need and utilize
     * pagination to limit the number of results returned. The default is <code>50</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     * <h3>Contact Creation Delay</h3>
     * <p>If a contact has recently been created, there is a possibility that it will not yet be available when searching. This means that it may not appear in the response. This delay can take a few minutes. If you need to be instantly notified it is recommended to use webhooks and iterate to see if they match your search filters.</p>
     * <h3>Nesting &amp; Limitations</h3>
     * <p>You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
     * There are some limitations to the amount of multiple's there can be:</p>
     * <ul>
     * <li>There's a limit of max 2 nested filters</li>
     * <li>There's a limit of max 15 filters for each AND or OR group</li>
     * </ul>
     * <h3>Searching for Timestamp Fields</h3>
     * <p>All timestamp fields (created_at, updated_at etc.) are indexed as Dates for Contact Search queries; Datetime queries are not currently supported. This means you can only query for timestamp fields by day - not hour, minute or second.
     * For example, if you search for all Contacts with a created_at value greater (&gt;) than 1577869200 (the UNIX timestamp for January 1st, 2020 9:00 AM), that will be interpreted as 1577836800 (January 1st, 2020 12:00 AM). The search results will then include Contacts created from January 2nd, 2020 12:00 AM onwards.
     * If you'd like to get contacts created on January 1st, 2020 you should search with a created_at value equal (=) to 1577836800 (January 1st, 2020 12:00 AM).
     * This behaviour applies only to timestamps used in search queries. The search results will still contain the full UNIX timestamp and be sorted accordingly.</p>
     * <h3>Accepted Fields</h3>
     * <p>Most key listed as part of the Contacts Model are searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as <code>created_at</code> accepts a date, the <code>value</code> cannot be a string such as <code>&quot;foorbar&quot;</code>).</p>
     * <p>| Field                              | Type                           |
     * | ---------------------------------- | ------------------------------ |
     * | id                                 | String                         |
     * | role                               | String&lt;br&gt;Accepts user or lead |
     * | name                               | String                         |
     * | avatar                             | String                         |
     * | owner_id                           | Integer                        |
     * | email                              | String                         |
     * | email_domain                       | String                         |
     * | phone                              | String                         |
     * | external_id                        | String                         |
     * | created_at                         | Date (UNIX Timestamp)          |
     * | signed_up_at                       | Date (UNIX Timestamp)          |
     * | updated_at                         | Date (UNIX Timestamp)          |
     * | last_seen_at                       | Date (UNIX Timestamp)          |
     * | last_contacted_at                  | Date (UNIX Timestamp)          |
     * | last_replied_at                    | Date (UNIX Timestamp)          |
     * | last_email_opened_at               | Date (UNIX Timestamp)          |
     * | last_email_clicked_at              | Date (UNIX Timestamp)          |
     * | language_override                  | String                         |
     * | browser                            | String                         |
     * | browser_language                   | String                         |
     * | os                                 | String                         |
     * | location.country                   | String                         |
     * | location.region                    | String                         |
     * | location.city                      | String                         |
     * | unsubscribed_from_emails           | Boolean                        |
     * | marked_email_as_spam               | Boolean                        |
     * | has_hard_bounced                   | Boolean                        |
     * | ios_last_seen_at                   | Date (UNIX Timestamp)          |
     * | ios_app_version                    | String                         |
     * | ios_device                         | String                         |
     * | ios_app_device                     | String                         |
     * | ios_os_version                     | String                         |
     * | ios_app_name                       | String                         |
     * | ios_sdk_version                    | String                         |
     * | android_last_seen_at               | Date (UNIX Timestamp)          |
     * | android_app_version                | String                         |
     * | android_device                     | String                         |
     * | android_app_name                   | String                         |
     * | andoid_sdk_version                 | String                         |
     * | segment_id                         | String                         |
     * | tag_id                             | String                         |
     * | custom_attributes.{attribute_name} | String                         |</p>
     * <h3>Accepted Operators</h3>
     * <p>{% admonition type=&quot;warning&quot; name=&quot;Searching based on <code>created_at</code>&quot; %}
     * You cannot use the <code>&lt;=</code> or <code>&gt;=</code> operators to search by <code>created_at</code>.
     * {% /admonition %}</p>
     * <p>The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (<code>&quot;=&quot;</code>). The operator has to be compatible with the field's type (eg. you cannot search with <code>&gt;</code> for a given string value as it's only compatible for integer's and dates).</p>
     * <p>| Operator | Valid Types                      | Description                                                      |
     * | :------- | :------------------------------- | :--------------------------------------------------------------- |
     * | =        | All                              | Equals                                                           |
     * | !=       | All                              | Doesn't Equal                                                    |
     * | IN       | All                              | In&lt;br&gt;Shortcut for <code>OR</code> queries&lt;br&gt;Values must be in Array       |
     * | NIN      | All                              | Not In&lt;br&gt;Shortcut for <code>OR !</code> queries&lt;br&gt;Values must be in Array |
     * | &gt;        | Integer&lt;br&gt;Date (UNIX Timestamp) | Greater than                                                     |
     * | &lt;       | Integer&lt;br&gt;Date (UNIX Timestamp) | Lower than                                                       |
     * | ~        | String                           | Contains                                                         |
     * | !~       | String                           | Doesn't Contain                                                  |
     * | ^        | String                           | Starts With                                                      |
     * | $        | String                           | Ends With                                                        |</p>
     */
    public CompletableFuture<SyncPagingIterable<Contact>> search(SearchRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of all contacts (ie. users or leads) in your workspace.
     * {% admonition type=&quot;warning&quot; name=&quot;Pagination&quot; %}
     * You can use pagination to limit the number of results returned. The default is <code>50</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}
     */
    public CompletableFuture<SyncPagingIterable<Contact>> list() {
        return this.rawClient.list().thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of all contacts (ie. users or leads) in your workspace.
     * {% admonition type=&quot;warning&quot; name=&quot;Pagination&quot; %}
     * You can use pagination to limit the number of results returned. The default is <code>50</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}
     */
    public CompletableFuture<SyncPagingIterable<Contact>> list(ListContactsRequest request) {
        return this.rawClient.list(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch a list of all contacts (ie. users or leads) in your workspace.
     * {% admonition type=&quot;warning&quot; name=&quot;Pagination&quot; %}
     * You can use pagination to limit the number of results returned. The default is <code>50</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}
     */
    public CompletableFuture<SyncPagingIterable<Contact>> list(
            ListContactsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can create a new contact (ie. user or lead).
     */
    public CompletableFuture<Contact> create(CreateContactRequest request) {
        return this.rawClient.create(request).thenApply(response -> response.body());
    }

    /**
     * You can create a new contact (ie. user or lead).
     */
    public CompletableFuture<Contact> create(CreateContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can archive a single contact.
     */
    public CompletableFuture<ContactArchived> archive(ArchiveContactRequest request) {
        return this.rawClient.archive(request).thenApply(response -> response.body());
    }

    /**
     * You can archive a single contact.
     */
    public CompletableFuture<ContactArchived> archive(ArchiveContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.archive(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can unarchive a single contact.
     */
    public CompletableFuture<ContactUnarchived> unarchive(UnarchiveContactRequest request) {
        return this.rawClient.unarchive(request).thenApply(response -> response.body());
    }

    /**
     * You can unarchive a single contact.
     */
    public CompletableFuture<ContactUnarchived> unarchive(
            UnarchiveContactRequest request, RequestOptions requestOptions) {
        return this.rawClient.unarchive(request, requestOptions).thenApply(response -> response.body());
    }
}
