/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.events.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListEventsRequest.Builder.class)
public final class ListEventsRequest {
    private final Optional<String> userId;

    private final Optional<String> intercomUserId;

    private final Optional<String> email;

    private final String type;

    private final Optional<Boolean> summary;

    private final Optional<Integer> perPage;

    private final Map<String, Object> additionalProperties;

    private ListEventsRequest(
            Optional<String> userId,
            Optional<String> intercomUserId,
            Optional<String> email,
            String type,
            Optional<Boolean> summary,
            Optional<Integer> perPage,
            Map<String, Object> additionalProperties) {
        this.userId = userId;
        this.intercomUserId = intercomUserId;
        this.email = email;
        this.type = type;
        this.summary = summary;
        this.perPage = perPage;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return user_id query parameter
     */
    @JsonProperty("user_id")
    public Optional<String> getUserId() {
        return userId;
    }

    /**
     * @return intercom_user_id query parameter
     */
    @JsonProperty("intercom_user_id")
    public Optional<String> getIntercomUserId() {
        return intercomUserId;
    }

    /**
     * @return email query parameter
     */
    @JsonProperty("email")
    public Optional<String> getEmail() {
        return email;
    }

    /**
     * @return The value must be user
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * @return summary flag
     */
    @JsonProperty("summary")
    public Optional<Boolean> getSummary() {
        return summary;
    }

    /**
     * @return How many results to display per page. Defaults to 15
     */
    @JsonProperty("per_page")
    public Optional<Integer> getPerPage() {
        return perPage;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListEventsRequest && equalTo((ListEventsRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListEventsRequest other) {
        return userId.equals(other.userId)
                && intercomUserId.equals(other.intercomUserId)
                && email.equals(other.email)
                && type.equals(other.type)
                && summary.equals(other.summary)
                && perPage.equals(other.perPage);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.userId, this.intercomUserId, this.email, this.type, this.summary, this.perPage);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public interface TypeStage {
        /**
         * The value must be user
         */
        _FinalStage type(@NotNull String type);

        Builder from(ListEventsRequest other);
    }

    public interface _FinalStage {
        ListEventsRequest build();

        /**
         * <p>user_id query parameter</p>
         */
        _FinalStage userId(Optional<String> userId);

        _FinalStage userId(String userId);

        /**
         * <p>intercom_user_id query parameter</p>
         */
        _FinalStage intercomUserId(Optional<String> intercomUserId);

        _FinalStage intercomUserId(String intercomUserId);

        /**
         * <p>email query parameter</p>
         */
        _FinalStage email(Optional<String> email);

        _FinalStage email(String email);

        /**
         * <p>summary flag</p>
         */
        _FinalStage summary(Optional<Boolean> summary);

        _FinalStage summary(Boolean summary);

        /**
         * <p>How many results to display per page. Defaults to 15</p>
         */
        _FinalStage perPage(Optional<Integer> perPage);

        _FinalStage perPage(Integer perPage);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TypeStage, _FinalStage {
        private String type;

        private Optional<Integer> perPage = Optional.empty();

        private Optional<Boolean> summary = Optional.empty();

        private Optional<String> email = Optional.empty();

        private Optional<String> intercomUserId = Optional.empty();

        private Optional<String> userId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ListEventsRequest other) {
            userId(other.getUserId());
            intercomUserId(other.getIntercomUserId());
            email(other.getEmail());
            type(other.getType());
            summary(other.getSummary());
            perPage(other.getPerPage());
            return this;
        }

        /**
         * The value must be user<p>The value must be user</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public _FinalStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * <p>How many results to display per page. Defaults to 15</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage perPage(Integer perPage) {
            this.perPage = Optional.ofNullable(perPage);
            return this;
        }

        /**
         * <p>How many results to display per page. Defaults to 15</p>
         */
        @java.lang.Override
        @JsonSetter(value = "per_page", nulls = Nulls.SKIP)
        public _FinalStage perPage(Optional<Integer> perPage) {
            this.perPage = perPage;
            return this;
        }

        /**
         * <p>summary flag</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage summary(Boolean summary) {
            this.summary = Optional.ofNullable(summary);
            return this;
        }

        /**
         * <p>summary flag</p>
         */
        @java.lang.Override
        @JsonSetter(value = "summary", nulls = Nulls.SKIP)
        public _FinalStage summary(Optional<Boolean> summary) {
            this.summary = summary;
            return this;
        }

        /**
         * <p>email query parameter</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage email(String email) {
            this.email = Optional.ofNullable(email);
            return this;
        }

        /**
         * <p>email query parameter</p>
         */
        @java.lang.Override
        @JsonSetter(value = "email", nulls = Nulls.SKIP)
        public _FinalStage email(Optional<String> email) {
            this.email = email;
            return this;
        }

        /**
         * <p>intercom_user_id query parameter</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage intercomUserId(String intercomUserId) {
            this.intercomUserId = Optional.ofNullable(intercomUserId);
            return this;
        }

        /**
         * <p>intercom_user_id query parameter</p>
         */
        @java.lang.Override
        @JsonSetter(value = "intercom_user_id", nulls = Nulls.SKIP)
        public _FinalStage intercomUserId(Optional<String> intercomUserId) {
            this.intercomUserId = intercomUserId;
            return this;
        }

        /**
         * <p>user_id query parameter</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        /**
         * <p>user_id query parameter</p>
         */
        @java.lang.Override
        @JsonSetter(value = "user_id", nulls = Nulls.SKIP)
        public _FinalStage userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        @java.lang.Override
        public ListEventsRequest build() {
            return new ListEventsRequest(userId, intercomUserId, email, type, summary, perPage, additionalProperties);
        }
    }
}
