/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.helpcenter.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = HelpCenter.Builder.class)
public final class HelpCenter {
    private final String id;

    private final String workspaceId;

    private final int createdAt;

    private final Optional<Integer> updatedAt;

    private final String identifier;

    private final boolean websiteTurnedOn;

    private final String displayName;

    private final Map<String, Object> additionalProperties;

    private HelpCenter(
            String id,
            String workspaceId,
            int createdAt,
            Optional<Integer> updatedAt,
            String identifier,
            boolean websiteTurnedOn,
            String displayName,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.workspaceId = workspaceId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.identifier = identifier;
        this.websiteTurnedOn = websiteTurnedOn;
        this.displayName = displayName;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the Help Center which is given by Intercom.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The id of the workspace which the Help Center belongs to.
     */
    @JsonProperty("workspace_id")
    public String getWorkspaceId() {
        return workspaceId;
    }

    /**
     * @return The time when the Help Center was created.
     */
    @JsonProperty("created_at")
    public int getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The time when the Help Center was last updated.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return The identifier of the Help Center. This is used in the URL of the Help Center.
     */
    @JsonProperty("identifier")
    public String getIdentifier() {
        return identifier;
    }

    /**
     * @return Whether the Help Center is turned on or not. This is controlled in your Help Center settings.
     */
    @JsonProperty("website_turned_on")
    public boolean getWebsiteTurnedOn() {
        return websiteTurnedOn;
    }

    /**
     * @return The display name of the Help Center only seen by teammates.
     */
    @JsonProperty("display_name")
    public String getDisplayName() {
        return displayName;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof HelpCenter && equalTo((HelpCenter) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(HelpCenter other) {
        return id.equals(other.id)
                && workspaceId.equals(other.workspaceId)
                && createdAt == other.createdAt
                && updatedAt.equals(other.updatedAt)
                && identifier.equals(other.identifier)
                && websiteTurnedOn == other.websiteTurnedOn
                && displayName.equals(other.displayName);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.workspaceId,
                this.createdAt,
                this.updatedAt,
                this.identifier,
                this.websiteTurnedOn,
                this.displayName);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The unique identifier for the Help Center which is given by Intercom.
         */
        WorkspaceIdStage id(@NotNull String id);

        Builder from(HelpCenter other);
    }

    public interface WorkspaceIdStage {
        /**
         * The id of the workspace which the Help Center belongs to.
         */
        CreatedAtStage workspaceId(@NotNull String workspaceId);
    }

    public interface CreatedAtStage {
        /**
         * The time when the Help Center was created.
         */
        IdentifierStage createdAt(int createdAt);
    }

    public interface IdentifierStage {
        /**
         * The identifier of the Help Center. This is used in the URL of the Help Center.
         */
        WebsiteTurnedOnStage identifier(@NotNull String identifier);
    }

    public interface WebsiteTurnedOnStage {
        /**
         * Whether the Help Center is turned on or not. This is controlled in your Help Center settings.
         */
        DisplayNameStage websiteTurnedOn(boolean websiteTurnedOn);
    }

    public interface DisplayNameStage {
        /**
         * The display name of the Help Center only seen by teammates.
         */
        _FinalStage displayName(@NotNull String displayName);
    }

    public interface _FinalStage {
        HelpCenter build();

        /**
         * <p>The time when the Help Center was last updated.</p>
         */
        _FinalStage updatedAt(Optional<Integer> updatedAt);

        _FinalStage updatedAt(Integer updatedAt);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements IdStage,
                    WorkspaceIdStage,
                    CreatedAtStage,
                    IdentifierStage,
                    WebsiteTurnedOnStage,
                    DisplayNameStage,
                    _FinalStage {
        private String id;

        private String workspaceId;

        private int createdAt;

        private String identifier;

        private boolean websiteTurnedOn;

        private String displayName;

        private Optional<Integer> updatedAt = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(HelpCenter other) {
            id(other.getId());
            workspaceId(other.getWorkspaceId());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            identifier(other.getIdentifier());
            websiteTurnedOn(other.getWebsiteTurnedOn());
            displayName(other.getDisplayName());
            return this;
        }

        /**
         * The unique identifier for the Help Center which is given by Intercom.<p>The unique identifier for the Help Center which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public WorkspaceIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * The id of the workspace which the Help Center belongs to.<p>The id of the workspace which the Help Center belongs to.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("workspace_id")
        public CreatedAtStage workspaceId(@NotNull String workspaceId) {
            this.workspaceId = Objects.requireNonNull(workspaceId, "workspaceId must not be null");
            return this;
        }

        /**
         * The time when the Help Center was created.<p>The time when the Help Center was created.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at")
        public IdentifierStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * The identifier of the Help Center. This is used in the URL of the Help Center.<p>The identifier of the Help Center. This is used in the URL of the Help Center.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("identifier")
        public WebsiteTurnedOnStage identifier(@NotNull String identifier) {
            this.identifier = Objects.requireNonNull(identifier, "identifier must not be null");
            return this;
        }

        /**
         * Whether the Help Center is turned on or not. This is controlled in your Help Center settings.<p>Whether the Help Center is turned on or not. This is controlled in your Help Center settings.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("website_turned_on")
        public DisplayNameStage websiteTurnedOn(boolean websiteTurnedOn) {
            this.websiteTurnedOn = websiteTurnedOn;
            return this;
        }

        /**
         * The display name of the Help Center only seen by teammates.<p>The display name of the Help Center only seen by teammates.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("display_name")
        public _FinalStage displayName(@NotNull String displayName) {
            this.displayName = Objects.requireNonNull(displayName, "displayName must not be null");
            return this;
        }

        /**
         * <p>The time when the Help Center was last updated.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>The time when the Help Center was last updated.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @java.lang.Override
        public HelpCenter build() {
            return new HelpCenter(
                    id,
                    workspaceId,
                    createdAt,
                    updatedAt,
                    identifier,
                    websiteTurnedOn,
                    displayName,
                    additionalProperties);
        }
    }
}
