/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.helpcenter.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = HelpCenterList.Builder.class)
public final class HelpCenterList {
    private final List<HelpCenter> data;

    private final Map<String, Object> additionalProperties;

    private HelpCenterList(List<HelpCenter> data, Map<String, Object> additionalProperties) {
        this.data = data;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the object - <code>list</code>.
     */
    @JsonProperty("type")
    public String getType() {
        return "list";
    }

    /**
     * @return An array of Help Center objects
     */
    @JsonProperty("data")
    public List<HelpCenter> getData() {
        return data;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof HelpCenterList && equalTo((HelpCenterList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(HelpCenterList other) {
        return data.equals(other.data);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.data);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private List<HelpCenter> data = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(HelpCenterList other) {
            data(other.getData());
            return this;
        }

        /**
         * <p>An array of Help Center objects</p>
         */
        @JsonSetter(value = "data", nulls = Nulls.SKIP)
        public Builder data(List<HelpCenter> data) {
            this.data.clear();
            this.data.addAll(data);
            return this;
        }

        public Builder addData(HelpCenter data) {
            this.data.add(data);
            return this;
        }

        public Builder addAllData(List<HelpCenter> data) {
            this.data.addAll(data);
            return this;
        }

        public HelpCenterList build() {
            return new HelpCenterList(data, additionalProperties);
        }
    }
}
