/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.news.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = NewsfeedAssignment.Builder.class)
public final class NewsfeedAssignment {
    private final int newsfeedId;

    private final int publishedAt;

    private final Map<String, Object> additionalProperties;

    private NewsfeedAssignment(int newsfeedId, int publishedAt, Map<String, Object> additionalProperties) {
        this.newsfeedId = newsfeedId;
        this.publishedAt = publishedAt;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the newsfeed which is given by Intercom. Publish dates cannot be in the future, to schedule news items use the dedicated feature in app (see this article).
     */
    @JsonProperty("newsfeed_id")
    public int getNewsfeedId() {
        return newsfeedId;
    }

    /**
     * @return Publish date of the news item on the newsfeed, use this field if you want to set a publish date in the past (e.g. when importing existing news items). On write, this field will be ignored if the news item state is &quot;draft&quot;.
     */
    @JsonProperty("published_at")
    public int getPublishedAt() {
        return publishedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof NewsfeedAssignment && equalTo((NewsfeedAssignment) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(NewsfeedAssignment other) {
        return newsfeedId == other.newsfeedId && publishedAt == other.publishedAt;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.newsfeedId, this.publishedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NewsfeedIdStage builder() {
        return new Builder();
    }

    public interface NewsfeedIdStage {
        /**
         * The unique identifier for the newsfeed which is given by Intercom. Publish dates cannot be in the future, to schedule news items use the dedicated feature in app (see this article).
         */
        PublishedAtStage newsfeedId(int newsfeedId);

        Builder from(NewsfeedAssignment other);
    }

    public interface PublishedAtStage {
        /**
         * Publish date of the news item on the newsfeed, use this field if you want to set a publish date in the past (e.g. when importing existing news items). On write, this field will be ignored if the news item state is "draft".
         */
        _FinalStage publishedAt(int publishedAt);
    }

    public interface _FinalStage {
        NewsfeedAssignment build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements NewsfeedIdStage, PublishedAtStage, _FinalStage {
        private int newsfeedId;

        private int publishedAt;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(NewsfeedAssignment other) {
            newsfeedId(other.getNewsfeedId());
            publishedAt(other.getPublishedAt());
            return this;
        }

        /**
         * The unique identifier for the newsfeed which is given by Intercom. Publish dates cannot be in the future, to schedule news items use the dedicated feature in app (see this article).<p>The unique identifier for the newsfeed which is given by Intercom. Publish dates cannot be in the future, to schedule news items use the dedicated feature in app (see this article).</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("newsfeed_id")
        public PublishedAtStage newsfeedId(int newsfeedId) {
            this.newsfeedId = newsfeedId;
            return this;
        }

        /**
         * Publish date of the news item on the newsfeed, use this field if you want to set a publish date in the past (e.g. when importing existing news items). On write, this field will be ignored if the news item state is "draft".<p>Publish date of the news item on the newsfeed, use this field if you want to set a publish date in the past (e.g. when importing existing news items). On write, this field will be ignored if the news item state is &quot;draft&quot;.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("published_at")
        public _FinalStage publishedAt(int publishedAt) {
            this.publishedAt = publishedAt;
            return this;
        }

        @java.lang.Override
        public NewsfeedAssignment build() {
            return new NewsfeedAssignment(newsfeedId, publishedAt, additionalProperties);
        }
    }
}
