/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.subscriptiontypes.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.Translation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SubscriptionType.Builder.class)
public final class SubscriptionType {
    private final String id;

    private final State state;

    private final Translation defaultTranslation;

    private final List<Translation> translations;

    private final ConsentType consentType;

    private final List<ContentTypesItem> contentTypes;

    private final Map<String, Object> additionalProperties;

    private SubscriptionType(
            String id,
            State state,
            Translation defaultTranslation,
            List<Translation> translations,
            ConsentType consentType,
            List<ContentTypesItem> contentTypes,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.state = state;
        this.defaultTranslation = defaultTranslation;
        this.translations = translations;
        this.consentType = consentType;
        this.contentTypes = contentTypes;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of the object - subscription
     */
    @JsonProperty("type")
    public String getType() {
        return "subscription";
    }

    /**
     * @return The unique identifier representing the subscription type.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The state of the subscription type.
     */
    @JsonProperty("state")
    public State getState() {
        return state;
    }

    @JsonProperty("default_translation")
    public Translation getDefaultTranslation() {
        return defaultTranslation;
    }

    /**
     * @return An array of translations objects with the localised version of the subscription type in each available locale within your translation settings.
     */
    @JsonProperty("translations")
    public List<Translation> getTranslations() {
        return translations;
    }

    /**
     * @return Describes the type of consent.
     */
    @JsonProperty("consent_type")
    public ConsentType getConsentType() {
        return consentType;
    }

    /**
     * @return The message types that this subscription supports - can contain <code>email</code> or <code>sms_message</code>.
     */
    @JsonProperty("content_types")
    public List<ContentTypesItem> getContentTypes() {
        return contentTypes;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SubscriptionType && equalTo((SubscriptionType) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SubscriptionType other) {
        return id.equals(other.id)
                && state.equals(other.state)
                && defaultTranslation.equals(other.defaultTranslation)
                && translations.equals(other.translations)
                && consentType.equals(other.consentType)
                && contentTypes.equals(other.contentTypes);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id, this.state, this.defaultTranslation, this.translations, this.consentType, this.contentTypes);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The unique identifier representing the subscription type.
         */
        StateStage id(@NotNull String id);

        Builder from(SubscriptionType other);
    }

    public interface StateStage {
        /**
         * The state of the subscription type.
         */
        DefaultTranslationStage state(@NotNull State state);
    }

    public interface DefaultTranslationStage {
        ConsentTypeStage defaultTranslation(@NotNull Translation defaultTranslation);
    }

    public interface ConsentTypeStage {
        /**
         * Describes the type of consent.
         */
        _FinalStage consentType(@NotNull ConsentType consentType);
    }

    public interface _FinalStage {
        SubscriptionType build();

        /**
         * <p>An array of translations objects with the localised version of the subscription type in each available locale within your translation settings.</p>
         */
        _FinalStage translations(List<Translation> translations);

        _FinalStage addTranslations(Translation translations);

        _FinalStage addAllTranslations(List<Translation> translations);

        /**
         * <p>The message types that this subscription supports - can contain <code>email</code> or <code>sms_message</code>.</p>
         */
        _FinalStage contentTypes(List<ContentTypesItem> contentTypes);

        _FinalStage addContentTypes(ContentTypesItem contentTypes);

        _FinalStage addAllContentTypes(List<ContentTypesItem> contentTypes);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements IdStage, StateStage, DefaultTranslationStage, ConsentTypeStage, _FinalStage {
        private String id;

        private State state;

        private Translation defaultTranslation;

        private ConsentType consentType;

        private List<ContentTypesItem> contentTypes = new ArrayList<>();

        private List<Translation> translations = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(SubscriptionType other) {
            id(other.getId());
            state(other.getState());
            defaultTranslation(other.getDefaultTranslation());
            translations(other.getTranslations());
            consentType(other.getConsentType());
            contentTypes(other.getContentTypes());
            return this;
        }

        /**
         * The unique identifier representing the subscription type.<p>The unique identifier representing the subscription type.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public StateStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * The state of the subscription type.<p>The state of the subscription type.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("state")
        public DefaultTranslationStage state(@NotNull State state) {
            this.state = Objects.requireNonNull(state, "state must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("default_translation")
        public ConsentTypeStage defaultTranslation(@NotNull Translation defaultTranslation) {
            this.defaultTranslation = Objects.requireNonNull(defaultTranslation, "defaultTranslation must not be null");
            return this;
        }

        /**
         * Describes the type of consent.<p>Describes the type of consent.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("consent_type")
        public _FinalStage consentType(@NotNull ConsentType consentType) {
            this.consentType = Objects.requireNonNull(consentType, "consentType must not be null");
            return this;
        }

        /**
         * <p>The message types that this subscription supports - can contain <code>email</code> or <code>sms_message</code>.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllContentTypes(List<ContentTypesItem> contentTypes) {
            this.contentTypes.addAll(contentTypes);
            return this;
        }

        /**
         * <p>The message types that this subscription supports - can contain <code>email</code> or <code>sms_message</code>.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addContentTypes(ContentTypesItem contentTypes) {
            this.contentTypes.add(contentTypes);
            return this;
        }

        /**
         * <p>The message types that this subscription supports - can contain <code>email</code> or <code>sms_message</code>.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "content_types", nulls = Nulls.SKIP)
        public _FinalStage contentTypes(List<ContentTypesItem> contentTypes) {
            this.contentTypes.clear();
            this.contentTypes.addAll(contentTypes);
            return this;
        }

        /**
         * <p>An array of translations objects with the localised version of the subscription type in each available locale within your translation settings.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllTranslations(List<Translation> translations) {
            this.translations.addAll(translations);
            return this;
        }

        /**
         * <p>An array of translations objects with the localised version of the subscription type in each available locale within your translation settings.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addTranslations(Translation translations) {
            this.translations.add(translations);
            return this;
        }

        /**
         * <p>An array of translations objects with the localised version of the subscription type in each available locale within your translation settings.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "translations", nulls = Nulls.SKIP)
        public _FinalStage translations(List<Translation> translations) {
            this.translations.clear();
            this.translations.addAll(translations);
            return this;
        }

        @java.lang.Override
        public SubscriptionType build() {
            return new SubscriptionType(
                    id, state, defaultTranslation, translations, consentType, contentTypes, additionalProperties);
        }
    }

    public static final class ConsentType {
        public static final ConsentType OPT_IN = new ConsentType(Value.OPT_IN, "opt_in");

        public static final ConsentType OPT_OUT = new ConsentType(Value.OPT_OUT, "opt_out");

        private final Value value;

        private final String string;

        ConsentType(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other)
                    || (other instanceof ConsentType && this.string.equals(((ConsentType) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case OPT_IN:
                    return visitor.visitOptIn();
                case OPT_OUT:
                    return visitor.visitOptOut();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static ConsentType valueOf(String value) {
            switch (value) {
                case "opt_in":
                    return OPT_IN;
                case "opt_out":
                    return OPT_OUT;
                default:
                    return new ConsentType(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            OPT_OUT,

            OPT_IN,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitOptOut();

            T visitOptIn();

            T visitUnknown(String unknownType);
        }
    }

    public static final class State {
        public static final State LIVE = new State(Value.LIVE, "live");

        public static final State ARCHIVED = new State(Value.ARCHIVED, "archived");

        public static final State DRAFT = new State(Value.DRAFT, "draft");

        private final Value value;

        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof State && this.string.equals(((State) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case LIVE:
                    return visitor.visitLive();
                case ARCHIVED:
                    return visitor.visitArchived();
                case DRAFT:
                    return visitor.visitDraft();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "live":
                    return LIVE;
                case "archived":
                    return ARCHIVED;
                case "draft":
                    return DRAFT;
                default:
                    return new State(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            LIVE,

            DRAFT,

            ARCHIVED,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitLive();

            T visitDraft();

            T visitArchived();

            T visitUnknown(String unknownType);
        }
    }

    public static final class ContentTypesItem {
        public static final ContentTypesItem EMAIL = new ContentTypesItem(Value.EMAIL, "email");

        public static final ContentTypesItem SMS_MESSAGE = new ContentTypesItem(Value.SMS_MESSAGE, "sms_message");

        private final Value value;

        private final String string;

        ContentTypesItem(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other)
                    || (other instanceof ContentTypesItem && this.string.equals(((ContentTypesItem) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case EMAIL:
                    return visitor.visitEmail();
                case SMS_MESSAGE:
                    return visitor.visitSmsMessage();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static ContentTypesItem valueOf(String value) {
            switch (value) {
                case "email":
                    return EMAIL;
                case "sms_message":
                    return SMS_MESSAGE;
                default:
                    return new ContentTypesItem(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            EMAIL,

            SMS_MESSAGE,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitEmail();

            T visitSmsMessage();

            T visitUnknown(String unknownType);
        }
    }
}
