/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.tickets;

import com.intercom.api.core.ClientOptions;
import com.intercom.api.core.RequestOptions;
import com.intercom.api.core.pagination.SyncPagingIterable;
import com.intercom.api.resources.tickets.requests.FindTicketRequest;
import com.intercom.api.resources.tickets.requests.ReplyToTicketRequest;
import com.intercom.api.resources.tickets.requests.UpdateTicketRequest;
import com.intercom.api.resources.tickets.types.Ticket;
import com.intercom.api.types.CreateTicketRequest;
import com.intercom.api.types.SearchRequest;
import com.intercom.api.types.TicketReply;
import java.util.concurrent.CompletableFuture;

public class AsyncTicketsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawTicketsClient rawClient;

    public AsyncTicketsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTicketsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawTicketsClient withRawResponse() {
        return this.rawClient;
    }

    /**
     * You can reply to a ticket with a message from an admin or on behalf of a contact, or with a note for admins.
     */
    public CompletableFuture<TicketReply> reply(ReplyToTicketRequest request) {
        return this.rawClient.reply(request).thenApply(response -> response.body());
    }

    /**
     * You can reply to a ticket with a message from an admin or on behalf of a contact, or with a note for admins.
     */
    public CompletableFuture<TicketReply> reply(ReplyToTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.reply(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can create a new ticket.
     */
    public CompletableFuture<Ticket> create(CreateTicketRequest request) {
        return this.rawClient.create(request).thenApply(response -> response.body());
    }

    /**
     * You can create a new ticket.
     */
    public CompletableFuture<Ticket> create(CreateTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single ticket.
     */
    public CompletableFuture<Ticket> get(FindTicketRequest request) {
        return this.rawClient.get(request).thenApply(response -> response.body());
    }

    /**
     * You can fetch the details of a single ticket.
     */
    public CompletableFuture<Ticket> get(FindTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can update a ticket.
     */
    public CompletableFuture<Ticket> update(UpdateTicketRequest request) {
        return this.rawClient.update(request).thenApply(response -> response.body());
    }

    /**
     * You can update a ticket.
     */
    public CompletableFuture<Ticket> update(UpdateTicketRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> response.body());
    }

    /**
     * You can search for multiple tickets by the value of their attributes in order to fetch exactly which ones you want.
     * <p>To search for tickets, you send a <code>POST</code> request to <code>https://api.intercom.io/tickets/search</code>.</p>
     * <p>This will accept a query object in the body which will define your filters.
     * {% admonition type=&quot;warning&quot; name=&quot;Optimizing search queries&quot; %}
     * Search queries can be complex, so optimizing them can help the performance of your search.
     * Use the <code>AND</code> and <code>OR</code> operators to combine multiple filters to get the exact results you need and utilize
     * pagination to limit the number of results returned. The default is <code>20</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     * <h3>Nesting &amp; Limitations</h3>
     * <p>You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
     * There are some limitations to the amount of multiples there can be:</p>
     * <ul>
     * <li>There's a limit of max 2 nested filters</li>
     * <li>There's a limit of max 15 filters for each AND or OR group</li>
     * </ul>
     * <h3>Accepted Fields</h3>
     * <p>Most keys listed as part of the Ticket model are searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as <code>created_at</code> accepts a date, the <code>value</code> cannot be a string such as <code>&quot;foobar&quot;</code>).</p>
     * <p>| Field                                     | Type                                                                                     |
     * | :---------------------------------------- | :--------------------------------------------------------------------------------------- |
     * | id                                        | String                                                                                   |
     * | created_at                                | Date (UNIX timestamp)                                                                    |
     * | updated_at                                | Date (UNIX timestamp)                                                                    |
     * | <em>default_title</em>                           | String                                                                                   |
     * | <em>default_description</em>                     | String                                                                                   |
     * | category                                  | String                                                                                   |
     * | ticket_type_id                            | String                                                                                   |
     * | contact_ids                               | String                                                                                   |
     * | teammate_ids                              | String                                                                                   |
     * | admin_assignee_id                         | String                                                                                   |
     * | team_assignee_id                          | String                                                                                   |
     * | open                                      | Boolean                                                                                  |
     * | state                                     | String                                                                                   |
     * | snoozed_until                             | Date (UNIX timestamp)                                                                    |
     * | ticket_attribute.{id}                     | String or Boolean or Date (UNIX timestamp) or Float or Integer                           |</p>
     * <h3>Accepted Operators</h3>
     * <p>{% admonition type=&quot;info&quot; name=&quot;Searching based on <code>created_at</code>&quot; %}
     * You may use the <code>&lt;=</code> or <code>&gt;=</code> operators to search by <code>created_at</code>.
     * {% /admonition %}</p>
     * <p>The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (<code>&quot;=&quot;</code>). The operator has to be compatible with the field's type  (eg. you cannot search with <code>&gt;</code> for a given string value as it's only compatible for integer's and dates).</p>
     * <p>| Operator | Valid Types                    | Description                                                  |
     * | :------- | :----------------------------- | :----------------------------------------------------------- |
     * | =        | All                            | Equals                                                       |
     * | !=       | All                            | Doesn't Equal                                                |
     * | IN       | All                            | In  Shortcut for <code>OR</code> queries  Values most be in Array       |
     * | NIN      | All                            | Not In  Shortcut for <code>OR !</code> queries  Values must be in Array |
     * | &gt;        | Integer  Date (UNIX Timestamp) | Greater (or equal) than                                      |
     * | &lt;       | Integer  Date (UNIX Timestamp) | Lower (or equal) than                                        |
     * | ~        | String                         | Contains                                                     |
     * | !~       | String                         | Doesn't Contain                                              |
     * | ^        | String                         | Starts With                                                  |
     * | $        | String                         | Ends With                                                    |</p>
     */
    public CompletableFuture<SyncPagingIterable<Ticket>> search(SearchRequest request) {
        return this.rawClient.search(request).thenApply(response -> response.body());
    }

    /**
     * You can search for multiple tickets by the value of their attributes in order to fetch exactly which ones you want.
     * <p>To search for tickets, you send a <code>POST</code> request to <code>https://api.intercom.io/tickets/search</code>.</p>
     * <p>This will accept a query object in the body which will define your filters.
     * {% admonition type=&quot;warning&quot; name=&quot;Optimizing search queries&quot; %}
     * Search queries can be complex, so optimizing them can help the performance of your search.
     * Use the <code>AND</code> and <code>OR</code> operators to combine multiple filters to get the exact results you need and utilize
     * pagination to limit the number of results returned. The default is <code>20</code> results per page.
     * See the <a href="https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request">pagination section</a> for more details on how to use the <code>starting_after</code> param.
     * {% /admonition %}</p>
     * <h3>Nesting &amp; Limitations</h3>
     * <p>You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
     * There are some limitations to the amount of multiples there can be:</p>
     * <ul>
     * <li>There's a limit of max 2 nested filters</li>
     * <li>There's a limit of max 15 filters for each AND or OR group</li>
     * </ul>
     * <h3>Accepted Fields</h3>
     * <p>Most keys listed as part of the Ticket model are searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as <code>created_at</code> accepts a date, the <code>value</code> cannot be a string such as <code>&quot;foobar&quot;</code>).</p>
     * <p>| Field                                     | Type                                                                                     |
     * | :---------------------------------------- | :--------------------------------------------------------------------------------------- |
     * | id                                        | String                                                                                   |
     * | created_at                                | Date (UNIX timestamp)                                                                    |
     * | updated_at                                | Date (UNIX timestamp)                                                                    |
     * | <em>default_title</em>                           | String                                                                                   |
     * | <em>default_description</em>                     | String                                                                                   |
     * | category                                  | String                                                                                   |
     * | ticket_type_id                            | String                                                                                   |
     * | contact_ids                               | String                                                                                   |
     * | teammate_ids                              | String                                                                                   |
     * | admin_assignee_id                         | String                                                                                   |
     * | team_assignee_id                          | String                                                                                   |
     * | open                                      | Boolean                                                                                  |
     * | state                                     | String                                                                                   |
     * | snoozed_until                             | Date (UNIX timestamp)                                                                    |
     * | ticket_attribute.{id}                     | String or Boolean or Date (UNIX timestamp) or Float or Integer                           |</p>
     * <h3>Accepted Operators</h3>
     * <p>{% admonition type=&quot;info&quot; name=&quot;Searching based on <code>created_at</code>&quot; %}
     * You may use the <code>&lt;=</code> or <code>&gt;=</code> operators to search by <code>created_at</code>.
     * {% /admonition %}</p>
     * <p>The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (<code>&quot;=&quot;</code>). The operator has to be compatible with the field's type  (eg. you cannot search with <code>&gt;</code> for a given string value as it's only compatible for integer's and dates).</p>
     * <p>| Operator | Valid Types                    | Description                                                  |
     * | :------- | :----------------------------- | :----------------------------------------------------------- |
     * | =        | All                            | Equals                                                       |
     * | !=       | All                            | Doesn't Equal                                                |
     * | IN       | All                            | In  Shortcut for <code>OR</code> queries  Values most be in Array       |
     * | NIN      | All                            | Not In  Shortcut for <code>OR !</code> queries  Values must be in Array |
     * | &gt;        | Integer  Date (UNIX Timestamp) | Greater (or equal) than                                      |
     * | &lt;       | Integer  Date (UNIX Timestamp) | Lower (or equal) than                                        |
     * | ~        | String                         | Contains                                                     |
     * | !~       | String                         | Doesn't Contain                                              |
     * | ^        | String                         | Starts With                                                  |
     * | $        | String                         | Ends With                                                    |</p>
     */
    public CompletableFuture<SyncPagingIterable<Ticket>> search(SearchRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).thenApply(response -> response.body());
    }
}
