/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.aicontent.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateContentImportSourceRequest.Builder.class)
public final class UpdateContentImportSourceRequest {
    private final String id;

    private final SyncBehavior syncBehavior;

    private final Optional<Status> status;

    private final String url;

    private final Map<String, Object> additionalProperties;

    private UpdateContentImportSourceRequest(
            String id,
            SyncBehavior syncBehavior,
            Optional<Status> status,
            String url,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.syncBehavior = syncBehavior;
        this.status = status;
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the content import source which is given by Intercom.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return If you intend to create or update External Pages via the API, this should be set to <code>api</code>. You can not change the value to or from api.
     */
    @JsonProperty("sync_behavior")
    public SyncBehavior getSyncBehavior() {
        return syncBehavior;
    }

    /**
     * @return The status of the content import source.
     */
    @JsonProperty("status")
    public Optional<Status> getStatus() {
        return status;
    }

    /**
     * @return The URL of the content import source. This may only be different from the existing value if the sync behavior is API.
     */
    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateContentImportSourceRequest && equalTo((UpdateContentImportSourceRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateContentImportSourceRequest other) {
        return id.equals(other.id)
                && syncBehavior.equals(other.syncBehavior)
                && status.equals(other.status)
                && url.equals(other.url);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.syncBehavior, this.status, this.url);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The unique identifier for the content import source which is given by Intercom.
         */
        SyncBehaviorStage id(@NotNull String id);

        Builder from(UpdateContentImportSourceRequest other);
    }

    public interface SyncBehaviorStage {
        /**
         * If you intend to create or update External Pages via the API, this should be set to `api`. You can not change the value to or from api.
         */
        UrlStage syncBehavior(@NotNull SyncBehavior syncBehavior);
    }

    public interface UrlStage {
        /**
         * The URL of the content import source. This may only be different from the existing value if the sync behavior is API.
         */
        _FinalStage url(@NotNull String url);
    }

    public interface _FinalStage {
        UpdateContentImportSourceRequest build();

        /**
         * <p>The status of the content import source.</p>
         */
        _FinalStage status(Optional<Status> status);

        _FinalStage status(Status status);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, SyncBehaviorStage, UrlStage, _FinalStage {
        private String id;

        private SyncBehavior syncBehavior;

        private String url;

        private Optional<Status> status = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateContentImportSourceRequest other) {
            id(other.getId());
            syncBehavior(other.getSyncBehavior());
            status(other.getStatus());
            url(other.getUrl());
            return this;
        }

        /**
         * The unique identifier for the content import source which is given by Intercom.<p>The unique identifier for the content import source which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public SyncBehaviorStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * If you intend to create or update External Pages via the API, this should be set to `api`. You can not change the value to or from api.<p>If you intend to create or update External Pages via the API, this should be set to <code>api</code>. You can not change the value to or from api.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("sync_behavior")
        public UrlStage syncBehavior(@NotNull SyncBehavior syncBehavior) {
            this.syncBehavior = Objects.requireNonNull(syncBehavior, "syncBehavior must not be null");
            return this;
        }

        /**
         * The URL of the content import source. This may only be different from the existing value if the sync behavior is API.<p>The URL of the content import source. This may only be different from the existing value if the sync behavior is API.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("url")
        public _FinalStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        /**
         * <p>The status of the content import source.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage status(Status status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        /**
         * <p>The status of the content import source.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "status", nulls = Nulls.SKIP)
        public _FinalStage status(Optional<Status> status) {
            this.status = status;
            return this;
        }

        @java.lang.Override
        public UpdateContentImportSourceRequest build() {
            return new UpdateContentImportSourceRequest(id, syncBehavior, status, url, additionalProperties);
        }
    }

    public static final class Status {
        public static final Status DEACTIVATED = new Status(Value.DEACTIVATED, "deactivated");

        public static final Status ACTIVE = new Status(Value.ACTIVE, "active");

        private final Value value;

        private final String string;

        Status(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Status && this.string.equals(((Status) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case DEACTIVATED:
                    return visitor.visitDeactivated();
                case ACTIVE:
                    return visitor.visitActive();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Status valueOf(String value) {
            switch (value) {
                case "deactivated":
                    return DEACTIVATED;
                case "active":
                    return ACTIVE;
                default:
                    return new Status(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            ACTIVE,

            DEACTIVATED,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitActive();

            T visitDeactivated();

            T visitUnknown(String unknownType);
        }
    }

    public static final class SyncBehavior {
        public static final SyncBehavior AUTOMATED = new SyncBehavior(Value.AUTOMATED, "automated");

        public static final SyncBehavior MANUAL = new SyncBehavior(Value.MANUAL, "manual");

        public static final SyncBehavior API = new SyncBehavior(Value.API, "api");

        private final Value value;

        private final String string;

        SyncBehavior(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other)
                    || (other instanceof SyncBehavior && this.string.equals(((SyncBehavior) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case AUTOMATED:
                    return visitor.visitAutomated();
                case MANUAL:
                    return visitor.visitManual();
                case API:
                    return visitor.visitApi();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static SyncBehavior valueOf(String value) {
            switch (value) {
                case "automated":
                    return AUTOMATED;
                case "manual":
                    return MANUAL;
                case "api":
                    return API;
                default:
                    return new SyncBehavior(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            API,

            AUTOMATED,

            MANUAL,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitApi();

            T visitAutomated();

            T visitManual();

            T visitUnknown(String unknownType);
        }
    }
}
