/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = AttachContactToACompanyRequest.Builder.class)
public final class AttachContactToACompanyRequest {
    private final String id;

    private final String companyId;

    private final Map<String, Object> additionalProperties;

    private AttachContactToACompanyRequest(String id, String companyId, Map<String, Object> additionalProperties) {
        this.id = id;
        this.companyId = companyId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the contact which is given by Intercom
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The unique identifier for the company which is given by Intercom
     */
    @JsonProperty("company_id")
    public String getCompanyId() {
        return companyId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AttachContactToACompanyRequest && equalTo((AttachContactToACompanyRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AttachContactToACompanyRequest other) {
        return id.equals(other.id) && companyId.equals(other.companyId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.companyId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The unique identifier for the contact which is given by Intercom
         */
        CompanyIdStage id(@NotNull String id);

        Builder from(AttachContactToACompanyRequest other);
    }

    public interface CompanyIdStage {
        /**
         * The unique identifier for the company which is given by Intercom
         */
        _FinalStage companyId(@NotNull String companyId);
    }

    public interface _FinalStage {
        AttachContactToACompanyRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, CompanyIdStage, _FinalStage {
        private String id;

        private String companyId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(AttachContactToACompanyRequest other) {
            id(other.getId());
            companyId(other.getCompanyId());
            return this;
        }

        /**
         * The unique identifier for the contact which is given by Intercom<p>The unique identifier for the contact which is given by Intercom</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public CompanyIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * The unique identifier for the company which is given by Intercom<p>The unique identifier for the company which is given by Intercom</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("company_id")
        public _FinalStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @java.lang.Override
        public AttachContactToACompanyRequest build() {
            return new AttachContactToACompanyRequest(id, companyId, additionalProperties);
        }
    }
}
