/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.helpcenter.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = HelpCenter.Builder.class)
public final class HelpCenter {
    private final Optional<String> id;

    private final Optional<String> workspaceId;

    private final Optional<Integer> createdAt;

    private final Optional<Integer> updatedAt;

    private final Optional<String> identifier;

    private final Optional<Boolean> websiteTurnedOn;

    private final Optional<String> displayName;

    private final Map<String, Object> additionalProperties;

    private HelpCenter(
            Optional<String> id,
            Optional<String> workspaceId,
            Optional<Integer> createdAt,
            Optional<Integer> updatedAt,
            Optional<String> identifier,
            Optional<Boolean> websiteTurnedOn,
            Optional<String> displayName,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.workspaceId = workspaceId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.identifier = identifier;
        this.websiteTurnedOn = websiteTurnedOn;
        this.displayName = displayName;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the Help Center which is given by Intercom.
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return The id of the workspace which the Help Center belongs to.
     */
    @JsonProperty("workspace_id")
    public Optional<String> getWorkspaceId() {
        return workspaceId;
    }

    /**
     * @return The time when the Help Center was created.
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The time when the Help Center was last updated.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return The identifier of the Help Center. This is used in the URL of the Help Center.
     */
    @JsonProperty("identifier")
    public Optional<String> getIdentifier() {
        return identifier;
    }

    /**
     * @return Whether the Help Center is turned on or not. This is controlled in your Help Center settings.
     */
    @JsonProperty("website_turned_on")
    public Optional<Boolean> getWebsiteTurnedOn() {
        return websiteTurnedOn;
    }

    /**
     * @return The display name of the Help Center only seen by teammates.
     */
    @JsonProperty("display_name")
    public Optional<String> getDisplayName() {
        return displayName;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof HelpCenter && equalTo((HelpCenter) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(HelpCenter other) {
        return id.equals(other.id)
                && workspaceId.equals(other.workspaceId)
                && createdAt.equals(other.createdAt)
                && updatedAt.equals(other.updatedAt)
                && identifier.equals(other.identifier)
                && websiteTurnedOn.equals(other.websiteTurnedOn)
                && displayName.equals(other.displayName);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.id,
                this.workspaceId,
                this.createdAt,
                this.updatedAt,
                this.identifier,
                this.websiteTurnedOn,
                this.displayName);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();

        private Optional<String> workspaceId = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<String> identifier = Optional.empty();

        private Optional<Boolean> websiteTurnedOn = Optional.empty();

        private Optional<String> displayName = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(HelpCenter other) {
            id(other.getId());
            workspaceId(other.getWorkspaceId());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            identifier(other.getIdentifier());
            websiteTurnedOn(other.getWebsiteTurnedOn());
            displayName(other.getDisplayName());
            return this;
        }

        /**
         * <p>The unique identifier for the Help Center which is given by Intercom.</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The id of the workspace which the Help Center belongs to.</p>
         */
        @JsonSetter(value = "workspace_id", nulls = Nulls.SKIP)
        public Builder workspaceId(Optional<String> workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = Optional.ofNullable(workspaceId);
            return this;
        }

        /**
         * <p>The time when the Help Center was created.</p>
         */
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>The time when the Help Center was last updated.</p>
         */
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>The identifier of the Help Center. This is used in the URL of the Help Center.</p>
         */
        @JsonSetter(value = "identifier", nulls = Nulls.SKIP)
        public Builder identifier(Optional<String> identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = Optional.ofNullable(identifier);
            return this;
        }

        /**
         * <p>Whether the Help Center is turned on or not. This is controlled in your Help Center settings.</p>
         */
        @JsonSetter(value = "website_turned_on", nulls = Nulls.SKIP)
        public Builder websiteTurnedOn(Optional<Boolean> websiteTurnedOn) {
            this.websiteTurnedOn = websiteTurnedOn;
            return this;
        }

        public Builder websiteTurnedOn(Boolean websiteTurnedOn) {
            this.websiteTurnedOn = Optional.ofNullable(websiteTurnedOn);
            return this;
        }

        /**
         * <p>The display name of the Help Center only seen by teammates.</p>
         */
        @JsonSetter(value = "display_name", nulls = Nulls.SKIP)
        public Builder displayName(Optional<String> displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = Optional.ofNullable(displayName);
            return this;
        }

        public HelpCenter build() {
            return new HelpCenter(
                    id,
                    workspaceId,
                    createdAt,
                    updatedAt,
                    identifier,
                    websiteTurnedOn,
                    displayName,
                    additionalProperties);
        }
    }
}
