/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.tickets.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.unstable.types.FileAttribute;
import com.intercom.api.resources.unstable.types.LinkedObjectList;
import com.intercom.api.resources.unstable.types.TicketParts;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Ticket.Builder.class)
public final class Ticket {
    private final Optional<String> type;

    private final Optional<String> id;

    private final Optional<String> ticketId;

    private final Optional<Category> category;

    private final Optional<Map<String, TicketAttributesValue>> ticketAttributes;

    private final Optional<TicketState> ticketState;

    private final Optional<TicketType> ticketType;

    private final Optional<TicketContacts> contacts;

    private final Optional<String> adminAssigneeId;

    private final Optional<String> teamAssigneeId;

    private final Optional<Integer> createdAt;

    private final Optional<Integer> updatedAt;

    private final Optional<Boolean> open;

    private final Optional<Integer> snoozedUntil;

    private final Optional<LinkedObjectList> linkedObjects;

    private final Optional<TicketParts> ticketParts;

    private final Optional<Boolean> isShared;

    private final Map<String, Object> additionalProperties;

    private Ticket(
            Optional<String> type,
            Optional<String> id,
            Optional<String> ticketId,
            Optional<Category> category,
            Optional<Map<String, TicketAttributesValue>> ticketAttributes,
            Optional<TicketState> ticketState,
            Optional<TicketType> ticketType,
            Optional<TicketContacts> contacts,
            Optional<String> adminAssigneeId,
            Optional<String> teamAssigneeId,
            Optional<Integer> createdAt,
            Optional<Integer> updatedAt,
            Optional<Boolean> open,
            Optional<Integer> snoozedUntil,
            Optional<LinkedObjectList> linkedObjects,
            Optional<TicketParts> ticketParts,
            Optional<Boolean> isShared,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.ticketId = ticketId;
        this.category = category;
        this.ticketAttributes = ticketAttributes;
        this.ticketState = ticketState;
        this.ticketType = ticketType;
        this.contacts = contacts;
        this.adminAssigneeId = adminAssigneeId;
        this.teamAssigneeId = teamAssigneeId;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.open = open;
        this.snoozedUntil = snoozedUntil;
        this.linkedObjects = linkedObjects;
        this.ticketParts = ticketParts;
        this.isShared = isShared;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Always ticket
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The unique identifier for the ticket which is given by Intercom.
     */
    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    /**
     * @return The ID of the Ticket used in the Intercom Inbox and Messenger. Do not use ticket_id for API queries.
     */
    @JsonProperty("ticket_id")
    public Optional<String> getTicketId() {
        return ticketId;
    }

    /**
     * @return Category of the Ticket.
     */
    @JsonProperty("category")
    public Optional<Category> getCategory() {
        return category;
    }

    @JsonProperty("ticket_attributes")
    public Optional<Map<String, TicketAttributesValue>> getTicketAttributes() {
        return ticketAttributes;
    }

    @JsonProperty("ticket_state")
    public Optional<TicketState> getTicketState() {
        return ticketState;
    }

    @JsonProperty("ticket_type")
    public Optional<TicketType> getTicketType() {
        return ticketType;
    }

    @JsonProperty("contacts")
    public Optional<TicketContacts> getContacts() {
        return contacts;
    }

    /**
     * @return The id representing the admin assigned to the ticket.
     */
    @JsonProperty("admin_assignee_id")
    public Optional<String> getAdminAssigneeId() {
        return adminAssigneeId;
    }

    /**
     * @return The id representing the team assigned to the ticket.
     */
    @JsonProperty("team_assignee_id")
    public Optional<String> getTeamAssigneeId() {
        return teamAssigneeId;
    }

    /**
     * @return The time the ticket was created as a UTC Unix timestamp.
     */
    @JsonProperty("created_at")
    public Optional<Integer> getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The last time the ticket was updated as a UTC Unix timestamp.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return Whether or not the ticket is open. If false, the ticket is closed.
     */
    @JsonProperty("open")
    public Optional<Boolean> getOpen() {
        return open;
    }

    /**
     * @return The time the ticket will be snoozed until as a UTC Unix timestamp. If null, the ticket is not currently snoozed.
     */
    @JsonProperty("snoozed_until")
    public Optional<Integer> getSnoozedUntil() {
        return snoozedUntil;
    }

    @JsonProperty("linked_objects")
    public Optional<LinkedObjectList> getLinkedObjects() {
        return linkedObjects;
    }

    @JsonProperty("ticket_parts")
    public Optional<TicketParts> getTicketParts() {
        return ticketParts;
    }

    /**
     * @return Whether or not the ticket is shared with the customer.
     */
    @JsonProperty("is_shared")
    public Optional<Boolean> getIsShared() {
        return isShared;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Ticket && equalTo((Ticket) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Ticket other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && ticketId.equals(other.ticketId)
                && category.equals(other.category)
                && ticketAttributes.equals(other.ticketAttributes)
                && ticketState.equals(other.ticketState)
                && ticketType.equals(other.ticketType)
                && contacts.equals(other.contacts)
                && adminAssigneeId.equals(other.adminAssigneeId)
                && teamAssigneeId.equals(other.teamAssigneeId)
                && createdAt.equals(other.createdAt)
                && updatedAt.equals(other.updatedAt)
                && open.equals(other.open)
                && snoozedUntil.equals(other.snoozedUntil)
                && linkedObjects.equals(other.linkedObjects)
                && ticketParts.equals(other.ticketParts)
                && isShared.equals(other.isShared);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.id,
                this.ticketId,
                this.category,
                this.ticketAttributes,
                this.ticketState,
                this.ticketType,
                this.contacts,
                this.adminAssigneeId,
                this.teamAssigneeId,
                this.createdAt,
                this.updatedAt,
                this.open,
                this.snoozedUntil,
                this.linkedObjects,
                this.ticketParts,
                this.isShared);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> type = Optional.empty();

        private Optional<String> id = Optional.empty();

        private Optional<String> ticketId = Optional.empty();

        private Optional<Category> category = Optional.empty();

        private Optional<Map<String, TicketAttributesValue>> ticketAttributes = Optional.empty();

        private Optional<TicketState> ticketState = Optional.empty();

        private Optional<TicketType> ticketType = Optional.empty();

        private Optional<TicketContacts> contacts = Optional.empty();

        private Optional<String> adminAssigneeId = Optional.empty();

        private Optional<String> teamAssigneeId = Optional.empty();

        private Optional<Integer> createdAt = Optional.empty();

        private Optional<Integer> updatedAt = Optional.empty();

        private Optional<Boolean> open = Optional.empty();

        private Optional<Integer> snoozedUntil = Optional.empty();

        private Optional<LinkedObjectList> linkedObjects = Optional.empty();

        private Optional<TicketParts> ticketParts = Optional.empty();

        private Optional<Boolean> isShared = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(Ticket other) {
            type(other.getType());
            id(other.getId());
            ticketId(other.getTicketId());
            category(other.getCategory());
            ticketAttributes(other.getTicketAttributes());
            ticketState(other.getTicketState());
            ticketType(other.getTicketType());
            contacts(other.getContacts());
            adminAssigneeId(other.getAdminAssigneeId());
            teamAssigneeId(other.getTeamAssigneeId());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            open(other.getOpen());
            snoozedUntil(other.getSnoozedUntil());
            linkedObjects(other.getLinkedObjects());
            ticketParts(other.getTicketParts());
            isShared(other.getIsShared());
            return this;
        }

        /**
         * <p>Always ticket</p>
         */
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public Builder type(Optional<String> type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>The unique identifier for the ticket which is given by Intercom.</p>
         */
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        /**
         * <p>The ID of the Ticket used in the Intercom Inbox and Messenger. Do not use ticket_id for API queries.</p>
         */
        @JsonSetter(value = "ticket_id", nulls = Nulls.SKIP)
        public Builder ticketId(Optional<String> ticketId) {
            this.ticketId = ticketId;
            return this;
        }

        public Builder ticketId(String ticketId) {
            this.ticketId = Optional.ofNullable(ticketId);
            return this;
        }

        /**
         * <p>Category of the Ticket.</p>
         */
        @JsonSetter(value = "category", nulls = Nulls.SKIP)
        public Builder category(Optional<Category> category) {
            this.category = category;
            return this;
        }

        public Builder category(Category category) {
            this.category = Optional.ofNullable(category);
            return this;
        }

        @JsonSetter(value = "ticket_attributes", nulls = Nulls.SKIP)
        public Builder ticketAttributes(Optional<Map<String, TicketAttributesValue>> ticketAttributes) {
            this.ticketAttributes = ticketAttributes;
            return this;
        }

        public Builder ticketAttributes(Map<String, TicketAttributesValue> ticketAttributes) {
            this.ticketAttributes = Optional.ofNullable(ticketAttributes);
            return this;
        }

        @JsonSetter(value = "ticket_state", nulls = Nulls.SKIP)
        public Builder ticketState(Optional<TicketState> ticketState) {
            this.ticketState = ticketState;
            return this;
        }

        public Builder ticketState(TicketState ticketState) {
            this.ticketState = Optional.ofNullable(ticketState);
            return this;
        }

        @JsonSetter(value = "ticket_type", nulls = Nulls.SKIP)
        public Builder ticketType(Optional<TicketType> ticketType) {
            this.ticketType = ticketType;
            return this;
        }

        public Builder ticketType(TicketType ticketType) {
            this.ticketType = Optional.ofNullable(ticketType);
            return this;
        }

        @JsonSetter(value = "contacts", nulls = Nulls.SKIP)
        public Builder contacts(Optional<TicketContacts> contacts) {
            this.contacts = contacts;
            return this;
        }

        public Builder contacts(TicketContacts contacts) {
            this.contacts = Optional.ofNullable(contacts);
            return this;
        }

        /**
         * <p>The id representing the admin assigned to the ticket.</p>
         */
        @JsonSetter(value = "admin_assignee_id", nulls = Nulls.SKIP)
        public Builder adminAssigneeId(Optional<String> adminAssigneeId) {
            this.adminAssigneeId = adminAssigneeId;
            return this;
        }

        public Builder adminAssigneeId(String adminAssigneeId) {
            this.adminAssigneeId = Optional.ofNullable(adminAssigneeId);
            return this;
        }

        /**
         * <p>The id representing the team assigned to the ticket.</p>
         */
        @JsonSetter(value = "team_assignee_id", nulls = Nulls.SKIP)
        public Builder teamAssigneeId(Optional<String> teamAssigneeId) {
            this.teamAssigneeId = teamAssigneeId;
            return this;
        }

        public Builder teamAssigneeId(String teamAssigneeId) {
            this.teamAssigneeId = Optional.ofNullable(teamAssigneeId);
            return this;
        }

        /**
         * <p>The time the ticket was created as a UTC Unix timestamp.</p>
         */
        @JsonSetter(value = "created_at", nulls = Nulls.SKIP)
        public Builder createdAt(Optional<Integer> createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder createdAt(Integer createdAt) {
            this.createdAt = Optional.ofNullable(createdAt);
            return this;
        }

        /**
         * <p>The last time the ticket was updated as a UTC Unix timestamp.</p>
         */
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public Builder updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>Whether or not the ticket is open. If false, the ticket is closed.</p>
         */
        @JsonSetter(value = "open", nulls = Nulls.SKIP)
        public Builder open(Optional<Boolean> open) {
            this.open = open;
            return this;
        }

        public Builder open(Boolean open) {
            this.open = Optional.ofNullable(open);
            return this;
        }

        /**
         * <p>The time the ticket will be snoozed until as a UTC Unix timestamp. If null, the ticket is not currently snoozed.</p>
         */
        @JsonSetter(value = "snoozed_until", nulls = Nulls.SKIP)
        public Builder snoozedUntil(Optional<Integer> snoozedUntil) {
            this.snoozedUntil = snoozedUntil;
            return this;
        }

        public Builder snoozedUntil(Integer snoozedUntil) {
            this.snoozedUntil = Optional.ofNullable(snoozedUntil);
            return this;
        }

        @JsonSetter(value = "linked_objects", nulls = Nulls.SKIP)
        public Builder linkedObjects(Optional<LinkedObjectList> linkedObjects) {
            this.linkedObjects = linkedObjects;
            return this;
        }

        public Builder linkedObjects(LinkedObjectList linkedObjects) {
            this.linkedObjects = Optional.ofNullable(linkedObjects);
            return this;
        }

        @JsonSetter(value = "ticket_parts", nulls = Nulls.SKIP)
        public Builder ticketParts(Optional<TicketParts> ticketParts) {
            this.ticketParts = ticketParts;
            return this;
        }

        public Builder ticketParts(TicketParts ticketParts) {
            this.ticketParts = Optional.ofNullable(ticketParts);
            return this;
        }

        /**
         * <p>Whether or not the ticket is shared with the customer.</p>
         */
        @JsonSetter(value = "is_shared", nulls = Nulls.SKIP)
        public Builder isShared(Optional<Boolean> isShared) {
            this.isShared = isShared;
            return this;
        }

        public Builder isShared(Boolean isShared) {
            this.isShared = Optional.ofNullable(isShared);
            return this;
        }

        public Ticket build() {
            return new Ticket(
                    type,
                    id,
                    ticketId,
                    category,
                    ticketAttributes,
                    ticketState,
                    ticketType,
                    contacts,
                    adminAssigneeId,
                    teamAssigneeId,
                    createdAt,
                    updatedAt,
                    open,
                    snoozedUntil,
                    linkedObjects,
                    ticketParts,
                    isShared,
                    additionalProperties);
        }
    }

    public static final class Category {
        public static final Category BACK_OFFICE = new Category(Value.BACK_OFFICE, "Back-office");

        public static final Category CUSTOMER = new Category(Value.CUSTOMER, "Customer");

        public static final Category TRACKER = new Category(Value.TRACKER, "Tracker");

        private final Value value;

        private final String string;

        Category(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Category && this.string.equals(((Category) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case BACK_OFFICE:
                    return visitor.visitBackOffice();
                case CUSTOMER:
                    return visitor.visitCustomer();
                case TRACKER:
                    return visitor.visitTracker();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Category valueOf(String value) {
            switch (value) {
                case "Back-office":
                    return BACK_OFFICE;
                case "Customer":
                    return CUSTOMER;
                case "Tracker":
                    return TRACKER;
                default:
                    return new Category(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            CUSTOMER,

            BACK_OFFICE,

            TRACKER,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitCustomer();

            T visitBackOffice();

            T visitTracker();

            T visitUnknown(String unknownType);
        }
    }

    @JsonDeserialize(using = TicketAttributesValue.Deserializer.class)
    public static final class TicketAttributesValue {
        private final Object value;

        private final int type;

        private TicketAttributesValue(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        @SuppressWarnings("unchecked")
        public <T> T visit(Visitor<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((Optional<String>) this.value);
            } else if (this.type == 1) {
                return visitor.visit((double) this.value);
            } else if (this.type == 2) {
                return visitor.visit((boolean) this.value);
            } else if (this.type == 3) {
                return visitor.visit((List<Object>) this.value);
            } else if (this.type == 4) {
                return visitor.visit((FileAttribute) this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof TicketAttributesValue && equalTo((TicketAttributesValue) other);
        }

        private boolean equalTo(TicketAttributesValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return this.value.toString();
        }

        public static TicketAttributesValue of(Optional<String> value) {
            return new TicketAttributesValue(value, 0);
        }

        public static TicketAttributesValue of(double value) {
            return new TicketAttributesValue(value, 1);
        }

        public static TicketAttributesValue of(boolean value) {
            return new TicketAttributesValue(value, 2);
        }

        public static TicketAttributesValue of(List<Object> value) {
            return new TicketAttributesValue(value, 3);
        }

        public static TicketAttributesValue of(FileAttribute value) {
            return new TicketAttributesValue(value, 4);
        }

        public interface Visitor<T> {
            T visit(Optional<String> value);

            T visit(double value);

            T visit(boolean value);

            T visit(List<Object> value);

            T visit(FileAttribute value);
        }

        static final class Deserializer extends StdDeserializer<TicketAttributesValue> {
            Deserializer() {
                super(TicketAttributesValue.class);
            }

            @java.lang.Override
            public TicketAttributesValue deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, new TypeReference<Optional<String>>() {}));
                } catch (IllegalArgumentException e) {
                }
                if (value instanceof Double) {
                    return of((Double) value);
                }
                if (value instanceof Boolean) {
                    return of((Boolean) value);
                }
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, new TypeReference<List<Object>>() {}));
                } catch (IllegalArgumentException e) {
                }
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, FileAttribute.class));
                } catch (IllegalArgumentException e) {
                }
                throw new JsonParseException(p, "Failed to deserialize");
            }
        }
    }
}
