/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.tickettypeattributes.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateTicketTypeAttributeRequest.Builder.class)
public final class UpdateTicketTypeAttributeRequest {
    private final String ticketTypeId;

    private final String id;

    private final Optional<String> name;

    private final Optional<String> description;

    private final Optional<Boolean> requiredToCreate;

    private final Optional<Boolean> requiredToCreateForContacts;

    private final Optional<Boolean> visibleOnCreate;

    private final Optional<Boolean> visibleToContacts;

    private final Optional<Boolean> multiline;

    private final Optional<String> listItems;

    private final Optional<Boolean> allowMultipleValues;

    private final Optional<Boolean> archived;

    private final Map<String, Object> additionalProperties;

    private UpdateTicketTypeAttributeRequest(
            String ticketTypeId,
            String id,
            Optional<String> name,
            Optional<String> description,
            Optional<Boolean> requiredToCreate,
            Optional<Boolean> requiredToCreateForContacts,
            Optional<Boolean> visibleOnCreate,
            Optional<Boolean> visibleToContacts,
            Optional<Boolean> multiline,
            Optional<String> listItems,
            Optional<Boolean> allowMultipleValues,
            Optional<Boolean> archived,
            Map<String, Object> additionalProperties) {
        this.ticketTypeId = ticketTypeId;
        this.id = id;
        this.name = name;
        this.description = description;
        this.requiredToCreate = requiredToCreate;
        this.requiredToCreateForContacts = requiredToCreateForContacts;
        this.visibleOnCreate = visibleOnCreate;
        this.visibleToContacts = visibleToContacts;
        this.multiline = multiline;
        this.listItems = listItems;
        this.allowMultipleValues = allowMultipleValues;
        this.archived = archived;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the ticket type which is given by Intercom.
     */
    @JsonProperty("ticket_type_id")
    public String getTicketTypeId() {
        return ticketTypeId;
    }

    /**
     * @return The unique identifier for the ticket type attribute which is given by Intercom.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The name of the ticket type attribute
     */
    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    /**
     * @return The description of the attribute presented to the teammate or contact
     */
    @JsonProperty("description")
    public Optional<String> getDescription() {
        return description;
    }

    /**
     * @return Whether the attribute is required to be filled in when teammates are creating the ticket in Inbox.
     */
    @JsonProperty("required_to_create")
    public Optional<Boolean> getRequiredToCreate() {
        return requiredToCreate;
    }

    /**
     * @return Whether the attribute is required to be filled in when contacts are creating the ticket in Messenger.
     */
    @JsonProperty("required_to_create_for_contacts")
    public Optional<Boolean> getRequiredToCreateForContacts() {
        return requiredToCreateForContacts;
    }

    /**
     * @return Whether the attribute is visible to teammates when creating a ticket in Inbox.
     */
    @JsonProperty("visible_on_create")
    public Optional<Boolean> getVisibleOnCreate() {
        return visibleOnCreate;
    }

    /**
     * @return Whether the attribute is visible to contacts when creating a ticket in Messenger.
     */
    @JsonProperty("visible_to_contacts")
    public Optional<Boolean> getVisibleToContacts() {
        return visibleToContacts;
    }

    /**
     * @return Whether the attribute allows multiple lines of text (only applicable to string attributes)
     */
    @JsonProperty("multiline")
    public Optional<Boolean> getMultiline() {
        return multiline;
    }

    /**
     * @return A comma delimited list of items for the attribute value (only applicable to list attributes)
     */
    @JsonProperty("list_items")
    public Optional<String> getListItems() {
        return listItems;
    }

    /**
     * @return Whether the attribute allows multiple files to be attached to it (only applicable to file attributes)
     */
    @JsonProperty("allow_multiple_values")
    public Optional<Boolean> getAllowMultipleValues() {
        return allowMultipleValues;
    }

    /**
     * @return Whether the attribute should be archived and not shown during creation of the ticket (it will still be present on previously created tickets)
     */
    @JsonProperty("archived")
    public Optional<Boolean> getArchived() {
        return archived;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateTicketTypeAttributeRequest && equalTo((UpdateTicketTypeAttributeRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateTicketTypeAttributeRequest other) {
        return ticketTypeId.equals(other.ticketTypeId)
                && id.equals(other.id)
                && name.equals(other.name)
                && description.equals(other.description)
                && requiredToCreate.equals(other.requiredToCreate)
                && requiredToCreateForContacts.equals(other.requiredToCreateForContacts)
                && visibleOnCreate.equals(other.visibleOnCreate)
                && visibleToContacts.equals(other.visibleToContacts)
                && multiline.equals(other.multiline)
                && listItems.equals(other.listItems)
                && allowMultipleValues.equals(other.allowMultipleValues)
                && archived.equals(other.archived);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.ticketTypeId,
                this.id,
                this.name,
                this.description,
                this.requiredToCreate,
                this.requiredToCreateForContacts,
                this.visibleOnCreate,
                this.visibleToContacts,
                this.multiline,
                this.listItems,
                this.allowMultipleValues,
                this.archived);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TicketTypeIdStage builder() {
        return new Builder();
    }

    public interface TicketTypeIdStage {
        /**
         * The unique identifier for the ticket type which is given by Intercom.
         */
        IdStage ticketTypeId(@NotNull String ticketTypeId);

        Builder from(UpdateTicketTypeAttributeRequest other);
    }

    public interface IdStage {
        /**
         * The unique identifier for the ticket type attribute which is given by Intercom.
         */
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        UpdateTicketTypeAttributeRequest build();

        /**
         * <p>The name of the ticket type attribute</p>
         */
        _FinalStage name(Optional<String> name);

        _FinalStage name(String name);

        /**
         * <p>The description of the attribute presented to the teammate or contact</p>
         */
        _FinalStage description(Optional<String> description);

        _FinalStage description(String description);

        /**
         * <p>Whether the attribute is required to be filled in when teammates are creating the ticket in Inbox.</p>
         */
        _FinalStage requiredToCreate(Optional<Boolean> requiredToCreate);

        _FinalStage requiredToCreate(Boolean requiredToCreate);

        /**
         * <p>Whether the attribute is required to be filled in when contacts are creating the ticket in Messenger.</p>
         */
        _FinalStage requiredToCreateForContacts(Optional<Boolean> requiredToCreateForContacts);

        _FinalStage requiredToCreateForContacts(Boolean requiredToCreateForContacts);

        /**
         * <p>Whether the attribute is visible to teammates when creating a ticket in Inbox.</p>
         */
        _FinalStage visibleOnCreate(Optional<Boolean> visibleOnCreate);

        _FinalStage visibleOnCreate(Boolean visibleOnCreate);

        /**
         * <p>Whether the attribute is visible to contacts when creating a ticket in Messenger.</p>
         */
        _FinalStage visibleToContacts(Optional<Boolean> visibleToContacts);

        _FinalStage visibleToContacts(Boolean visibleToContacts);

        /**
         * <p>Whether the attribute allows multiple lines of text (only applicable to string attributes)</p>
         */
        _FinalStage multiline(Optional<Boolean> multiline);

        _FinalStage multiline(Boolean multiline);

        /**
         * <p>A comma delimited list of items for the attribute value (only applicable to list attributes)</p>
         */
        _FinalStage listItems(Optional<String> listItems);

        _FinalStage listItems(String listItems);

        /**
         * <p>Whether the attribute allows multiple files to be attached to it (only applicable to file attributes)</p>
         */
        _FinalStage allowMultipleValues(Optional<Boolean> allowMultipleValues);

        _FinalStage allowMultipleValues(Boolean allowMultipleValues);

        /**
         * <p>Whether the attribute should be archived and not shown during creation of the ticket (it will still be present on previously created tickets)</p>
         */
        _FinalStage archived(Optional<Boolean> archived);

        _FinalStage archived(Boolean archived);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TicketTypeIdStage, IdStage, _FinalStage {
        private String ticketTypeId;

        private String id;

        private Optional<Boolean> archived = Optional.empty();

        private Optional<Boolean> allowMultipleValues = Optional.empty();

        private Optional<String> listItems = Optional.empty();

        private Optional<Boolean> multiline = Optional.empty();

        private Optional<Boolean> visibleToContacts = Optional.empty();

        private Optional<Boolean> visibleOnCreate = Optional.empty();

        private Optional<Boolean> requiredToCreateForContacts = Optional.empty();

        private Optional<Boolean> requiredToCreate = Optional.empty();

        private Optional<String> description = Optional.empty();

        private Optional<String> name = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateTicketTypeAttributeRequest other) {
            ticketTypeId(other.getTicketTypeId());
            id(other.getId());
            name(other.getName());
            description(other.getDescription());
            requiredToCreate(other.getRequiredToCreate());
            requiredToCreateForContacts(other.getRequiredToCreateForContacts());
            visibleOnCreate(other.getVisibleOnCreate());
            visibleToContacts(other.getVisibleToContacts());
            multiline(other.getMultiline());
            listItems(other.getListItems());
            allowMultipleValues(other.getAllowMultipleValues());
            archived(other.getArchived());
            return this;
        }

        /**
         * The unique identifier for the ticket type which is given by Intercom.<p>The unique identifier for the ticket type which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("ticket_type_id")
        public IdStage ticketTypeId(@NotNull String ticketTypeId) {
            this.ticketTypeId = Objects.requireNonNull(ticketTypeId, "ticketTypeId must not be null");
            return this;
        }

        /**
         * The unique identifier for the ticket type attribute which is given by Intercom.<p>The unique identifier for the ticket type attribute which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * <p>Whether the attribute should be archived and not shown during creation of the ticket (it will still be present on previously created tickets)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage archived(Boolean archived) {
            this.archived = Optional.ofNullable(archived);
            return this;
        }

        /**
         * <p>Whether the attribute should be archived and not shown during creation of the ticket (it will still be present on previously created tickets)</p>
         */
        @java.lang.Override
        @JsonSetter(value = "archived", nulls = Nulls.SKIP)
        public _FinalStage archived(Optional<Boolean> archived) {
            this.archived = archived;
            return this;
        }

        /**
         * <p>Whether the attribute allows multiple files to be attached to it (only applicable to file attributes)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage allowMultipleValues(Boolean allowMultipleValues) {
            this.allowMultipleValues = Optional.ofNullable(allowMultipleValues);
            return this;
        }

        /**
         * <p>Whether the attribute allows multiple files to be attached to it (only applicable to file attributes)</p>
         */
        @java.lang.Override
        @JsonSetter(value = "allow_multiple_values", nulls = Nulls.SKIP)
        public _FinalStage allowMultipleValues(Optional<Boolean> allowMultipleValues) {
            this.allowMultipleValues = allowMultipleValues;
            return this;
        }

        /**
         * <p>A comma delimited list of items for the attribute value (only applicable to list attributes)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage listItems(String listItems) {
            this.listItems = Optional.ofNullable(listItems);
            return this;
        }

        /**
         * <p>A comma delimited list of items for the attribute value (only applicable to list attributes)</p>
         */
        @java.lang.Override
        @JsonSetter(value = "list_items", nulls = Nulls.SKIP)
        public _FinalStage listItems(Optional<String> listItems) {
            this.listItems = listItems;
            return this;
        }

        /**
         * <p>Whether the attribute allows multiple lines of text (only applicable to string attributes)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage multiline(Boolean multiline) {
            this.multiline = Optional.ofNullable(multiline);
            return this;
        }

        /**
         * <p>Whether the attribute allows multiple lines of text (only applicable to string attributes)</p>
         */
        @java.lang.Override
        @JsonSetter(value = "multiline", nulls = Nulls.SKIP)
        public _FinalStage multiline(Optional<Boolean> multiline) {
            this.multiline = multiline;
            return this;
        }

        /**
         * <p>Whether the attribute is visible to contacts when creating a ticket in Messenger.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage visibleToContacts(Boolean visibleToContacts) {
            this.visibleToContacts = Optional.ofNullable(visibleToContacts);
            return this;
        }

        /**
         * <p>Whether the attribute is visible to contacts when creating a ticket in Messenger.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "visible_to_contacts", nulls = Nulls.SKIP)
        public _FinalStage visibleToContacts(Optional<Boolean> visibleToContacts) {
            this.visibleToContacts = visibleToContacts;
            return this;
        }

        /**
         * <p>Whether the attribute is visible to teammates when creating a ticket in Inbox.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage visibleOnCreate(Boolean visibleOnCreate) {
            this.visibleOnCreate = Optional.ofNullable(visibleOnCreate);
            return this;
        }

        /**
         * <p>Whether the attribute is visible to teammates when creating a ticket in Inbox.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "visible_on_create", nulls = Nulls.SKIP)
        public _FinalStage visibleOnCreate(Optional<Boolean> visibleOnCreate) {
            this.visibleOnCreate = visibleOnCreate;
            return this;
        }

        /**
         * <p>Whether the attribute is required to be filled in when contacts are creating the ticket in Messenger.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage requiredToCreateForContacts(Boolean requiredToCreateForContacts) {
            this.requiredToCreateForContacts = Optional.ofNullable(requiredToCreateForContacts);
            return this;
        }

        /**
         * <p>Whether the attribute is required to be filled in when contacts are creating the ticket in Messenger.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "required_to_create_for_contacts", nulls = Nulls.SKIP)
        public _FinalStage requiredToCreateForContacts(Optional<Boolean> requiredToCreateForContacts) {
            this.requiredToCreateForContacts = requiredToCreateForContacts;
            return this;
        }

        /**
         * <p>Whether the attribute is required to be filled in when teammates are creating the ticket in Inbox.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage requiredToCreate(Boolean requiredToCreate) {
            this.requiredToCreate = Optional.ofNullable(requiredToCreate);
            return this;
        }

        /**
         * <p>Whether the attribute is required to be filled in when teammates are creating the ticket in Inbox.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "required_to_create", nulls = Nulls.SKIP)
        public _FinalStage requiredToCreate(Optional<Boolean> requiredToCreate) {
            this.requiredToCreate = requiredToCreate;
            return this;
        }

        /**
         * <p>The description of the attribute presented to the teammate or contact</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        /**
         * <p>The description of the attribute presented to the teammate or contact</p>
         */
        @java.lang.Override
        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        /**
         * <p>The name of the ticket type attribute</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        /**
         * <p>The name of the ticket type attribute</p>
         */
        @java.lang.Override
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @java.lang.Override
        public UpdateTicketTypeAttributeRequest build() {
            return new UpdateTicketTypeAttributeRequest(
                    ticketTypeId,
                    id,
                    name,
                    description,
                    requiredToCreate,
                    requiredToCreateForContacts,
                    visibleOnCreate,
                    visibleToContacts,
                    multiline,
                    listItems,
                    allowMultipleValues,
                    archived,
                    additionalProperties);
        }
    }
}
