/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = NotFoundErrorBody.Builder.class)
public final class NotFoundErrorBody {
    private final String type;

    private final Optional<String> requestId;

    private final List<ErrorsItem> errors;

    private final Map<String, Object> additionalProperties;

    private NotFoundErrorBody(
            String type,
            Optional<String> requestId,
            List<ErrorsItem> errors,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.requestId = requestId;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type is error.list
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * @return
     */
    @JsonProperty("request_id")
    public Optional<String> getRequestId() {
        return requestId;
    }

    /**
     * @return An array of one or more error objects
     */
    @JsonProperty("errors")
    public List<ErrorsItem> getErrors() {
        return errors;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof NotFoundErrorBody && equalTo((NotFoundErrorBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(NotFoundErrorBody other) {
        return type.equals(other.type) && requestId.equals(other.requestId) && errors.equals(other.errors);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.requestId, this.errors);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public interface TypeStage {
        /**
         * The type is error.list
         */
        _FinalStage type(@NotNull String type);

        Builder from(NotFoundErrorBody other);
    }

    public interface _FinalStage {
        NotFoundErrorBody build();

        _FinalStage requestId(Optional<String> requestId);

        _FinalStage requestId(String requestId);

        /**
         * <p>An array of one or more error objects</p>
         */
        _FinalStage errors(List<ErrorsItem> errors);

        _FinalStage addErrors(ErrorsItem errors);

        _FinalStage addAllErrors(List<ErrorsItem> errors);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TypeStage, _FinalStage {
        private String type;

        private List<ErrorsItem> errors = new ArrayList<>();

        private Optional<String> requestId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(NotFoundErrorBody other) {
            type(other.getType());
            requestId(other.getRequestId());
            errors(other.getErrors());
            return this;
        }

        /**
         * The type is error.list<p>The type is error.list</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public _FinalStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * <p>An array of one or more error objects</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllErrors(List<ErrorsItem> errors) {
            this.errors.addAll(errors);
            return this;
        }

        /**
         * <p>An array of one or more error objects</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addErrors(ErrorsItem errors) {
            this.errors.add(errors);
            return this;
        }

        /**
         * <p>An array of one or more error objects</p>
         */
        @java.lang.Override
        @JsonSetter(value = "errors", nulls = Nulls.SKIP)
        public _FinalStage errors(List<ErrorsItem> errors) {
            this.errors.clear();
            this.errors.addAll(errors);
            return this;
        }

        /**
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage requestId(String requestId) {
            this.requestId = Optional.ofNullable(requestId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "request_id", nulls = Nulls.SKIP)
        public _FinalStage requestId(Optional<String> requestId) {
            this.requestId = requestId;
            return this;
        }

        @java.lang.Override
        public NotFoundErrorBody build() {
            return new NotFoundErrorBody(type, requestId, errors, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = ErrorsItem.Builder.class)
    public static final class ErrorsItem {
        private final String code;

        private final Optional<String> message;

        private final Map<String, Object> additionalProperties;

        private ErrorsItem(String code, Optional<String> message, Map<String, Object> additionalProperties) {
            this.code = code;
            this.message = message;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return ticket_not_found
         */
        @JsonProperty("code")
        public String getCode() {
            return code;
        }

        /**
         * @return Ticket not found
         */
        @JsonProperty("message")
        public Optional<String> getMessage() {
            return message;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof ErrorsItem && equalTo((ErrorsItem) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(ErrorsItem other) {
            return code.equals(other.code) && message.equals(other.message);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.code, this.message);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static CodeStage builder() {
            return new Builder();
        }

        public interface CodeStage {
            /**
             * ticket_not_found
             */
            _FinalStage code(@NotNull String code);

            Builder from(ErrorsItem other);
        }

        public interface _FinalStage {
            ErrorsItem build();

            /**
             * <p>Ticket not found</p>
             */
            _FinalStage message(Optional<String> message);

            _FinalStage message(String message);
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements CodeStage, _FinalStage {
            private String code;

            private Optional<String> message = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(ErrorsItem other) {
                code(other.getCode());
                message(other.getMessage());
                return this;
            }

            /**
             * ticket_not_found<p>ticket_not_found</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("code")
            public _FinalStage code(@NotNull String code) {
                this.code = Objects.requireNonNull(code, "code must not be null");
                return this;
            }

            /**
             * <p>Ticket not found</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage message(String message) {
                this.message = Optional.ofNullable(message);
                return this;
            }

            /**
             * <p>Ticket not found</p>
             */
            @java.lang.Override
            @JsonSetter(value = "message", nulls = Nulls.SKIP)
            public _FinalStage message(Optional<String> message) {
                this.message = message;
                return this;
            }

            @java.lang.Override
            public ErrorsItem build() {
                return new ErrorsItem(code, message, additionalProperties);
            }
        }
    }
}
