/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.unstable.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.intercom.api.core.ObjectMappers;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SearchRequest.Builder.class)
public final class SearchRequest {
    private final Query query;

    private final Optional<StartingAfterPaging> pagination;

    private final Map<String, Object> additionalProperties;

    private SearchRequest(
            Query query, Optional<StartingAfterPaging> pagination, Map<String, Object> additionalProperties) {
        this.query = query;
        this.pagination = pagination;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("query")
    public Query getQuery() {
        return query;
    }

    @JsonProperty("pagination")
    public Optional<StartingAfterPaging> getPagination() {
        return pagination;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SearchRequest && equalTo((SearchRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SearchRequest other) {
        return query.equals(other.query) && pagination.equals(other.pagination);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.query, this.pagination);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static QueryStage builder() {
        return new Builder();
    }

    public interface QueryStage {
        _FinalStage query(@NotNull Query query);

        Builder from(SearchRequest other);
    }

    public interface _FinalStage {
        SearchRequest build();

        _FinalStage pagination(Optional<StartingAfterPaging> pagination);

        _FinalStage pagination(StartingAfterPaging pagination);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements QueryStage, _FinalStage {
        private Query query;

        private Optional<StartingAfterPaging> pagination = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(SearchRequest other) {
            query(other.getQuery());
            pagination(other.getPagination());
            return this;
        }

        @java.lang.Override
        @JsonSetter("query")
        public _FinalStage query(@NotNull Query query) {
            this.query = Objects.requireNonNull(query, "query must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage pagination(StartingAfterPaging pagination) {
            this.pagination = Optional.ofNullable(pagination);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "pagination", nulls = Nulls.SKIP)
        public _FinalStage pagination(Optional<StartingAfterPaging> pagination) {
            this.pagination = pagination;
            return this;
        }

        @java.lang.Override
        public SearchRequest build() {
            return new SearchRequest(query, pagination, additionalProperties);
        }
    }

    @JsonDeserialize(using = Query.Deserializer.class)
    public static final class Query {
        private final Object value;

        private final int type;

        private Query(Object value, int type) {
            this.value = value;
            this.type = type;
        }

        @JsonValue
        public Object get() {
            return this.value;
        }

        @SuppressWarnings("unchecked")
        public <T> T visit(Visitor<T> visitor) {
            if (this.type == 0) {
                return visitor.visit((SingleFilterSearchRequest) this.value);
            } else if (this.type == 1) {
                return visitor.visit((MultipleFilterSearchRequest) this.value);
            }
            throw new IllegalStateException("Failed to visit value. This should never happen.");
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof Query && equalTo((Query) other);
        }

        private boolean equalTo(Query other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return this.value.toString();
        }

        public static Query of(SingleFilterSearchRequest value) {
            return new Query(value, 0);
        }

        public static Query of(MultipleFilterSearchRequest value) {
            return new Query(value, 1);
        }

        public interface Visitor<T> {
            T visit(SingleFilterSearchRequest value);

            T visit(MultipleFilterSearchRequest value);
        }

        static final class Deserializer extends StdDeserializer<Query> {
            Deserializer() {
                super(Query.class);
            }

            @java.lang.Override
            public Query deserialize(JsonParser p, DeserializationContext context) throws IOException {
                Object value = p.readValueAs(Object.class);
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, SingleFilterSearchRequest.class));
                } catch (IllegalArgumentException e) {
                }
                try {
                    return of(ObjectMappers.JSON_MAPPER.convertValue(value, MultipleFilterSearchRequest.class));
                } catch (IllegalArgumentException e) {
                }
                throw new JsonParseException(p, "Failed to deserialize");
            }
        }
    }
}
