/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = AddressableList.Builder.class)
public final class AddressableList {
    private final String type;

    private final String id;

    private final String url;

    private final Map<String, Object> additionalProperties;

    private AddressableList(String type, String id, String url, Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The addressable object type
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * @return The id of the addressable object
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return Url to get more company resources for this contact
     */
    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AddressableList && equalTo((AddressableList) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AddressableList other) {
        return type.equals(other.type) && id.equals(other.id) && url.equals(other.url);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.id, this.url);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public interface TypeStage {
        /**
         * The addressable object type
         */
        IdStage type(@NotNull String type);

        Builder from(AddressableList other);
    }

    public interface IdStage {
        /**
         * The id of the addressable object
         */
        UrlStage id(@NotNull String id);
    }

    public interface UrlStage {
        /**
         * Url to get more company resources for this contact
         */
        _FinalStage url(@NotNull String url);
    }

    public interface _FinalStage {
        AddressableList build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TypeStage, IdStage, UrlStage, _FinalStage {
        private String type;

        private String id;

        private String url;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(AddressableList other) {
            type(other.getType());
            id(other.getId());
            url(other.getUrl());
            return this;
        }

        /**
         * The addressable object type<p>The addressable object type</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public IdStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * The id of the addressable object<p>The id of the addressable object</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public UrlStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * Url to get more company resources for this contact<p>Url to get more company resources for this contact</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("url")
        public _FinalStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @java.lang.Override
        public AddressableList build() {
            return new AddressableList(type, id, url, additionalProperties);
        }
    }
}
