/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = AssignConversationRequest.Builder.class)
public final class AssignConversationRequest {
    private final Type type;

    private final String adminId;

    private final String assigneeId;

    private final Optional<String> body;

    private final Map<String, Object> additionalProperties;

    private AssignConversationRequest(
            Type type,
            String adminId,
            String assigneeId,
            Optional<String> body,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.adminId = adminId;
        this.assigneeId = assigneeId;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("type")
    public Type getType() {
        return type;
    }

    /**
     * @return The id of the admin who is performing the action.
     */
    @JsonProperty("admin_id")
    public String getAdminId() {
        return adminId;
    }

    /**
     * @return The <code>id</code> of the <code>admin</code> or <code>team</code> which will be assigned the conversation. A conversation can be assigned both an admin and a team.\nSet <code>0</code> if you want this assign to no admin or team (ie. Unassigned).
     */
    @JsonProperty("assignee_id")
    public String getAssigneeId() {
        return assigneeId;
    }

    /**
     * @return Optionally you can send a response in the conversation when it is assigned.
     */
    @JsonProperty("body")
    public Optional<String> getBody() {
        return body;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AssignConversationRequest && equalTo((AssignConversationRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AssignConversationRequest other) {
        return type.equals(other.type)
                && adminId.equals(other.adminId)
                && assigneeId.equals(other.assigneeId)
                && body.equals(other.body);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.type, this.adminId, this.assigneeId, this.body);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    public interface TypeStage {
        AdminIdStage type(@NotNull Type type);

        Builder from(AssignConversationRequest other);
    }

    public interface AdminIdStage {
        /**
         * The id of the admin who is performing the action.
         */
        AssigneeIdStage adminId(@NotNull String adminId);
    }

    public interface AssigneeIdStage {
        /**
         * The `id` of the `admin` or `team` which will be assigned the conversation. A conversation can be assigned both an admin and a team.\nSet `0` if you want this assign to no admin or team (ie. Unassigned).
         */
        _FinalStage assigneeId(@NotNull String assigneeId);
    }

    public interface _FinalStage {
        AssignConversationRequest build();

        /**
         * <p>Optionally you can send a response in the conversation when it is assigned.</p>
         */
        _FinalStage body(Optional<String> body);

        _FinalStage body(String body);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TypeStage, AdminIdStage, AssigneeIdStage, _FinalStage {
        private Type type;

        private String adminId;

        private String assigneeId;

        private Optional<String> body = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(AssignConversationRequest other) {
            type(other.getType());
            adminId(other.getAdminId());
            assigneeId(other.getAssigneeId());
            body(other.getBody());
            return this;
        }

        @java.lang.Override
        @JsonSetter("type")
        public AdminIdStage type(@NotNull Type type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * The id of the admin who is performing the action.<p>The id of the admin who is performing the action.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("admin_id")
        public AssigneeIdStage adminId(@NotNull String adminId) {
            this.adminId = Objects.requireNonNull(adminId, "adminId must not be null");
            return this;
        }

        /**
         * The `id` of the `admin` or `team` which will be assigned the conversation. A conversation can be assigned both an admin and a team.\nSet `0` if you want this assign to no admin or team (ie. Unassigned).<p>The <code>id</code> of the <code>admin</code> or <code>team</code> which will be assigned the conversation. A conversation can be assigned both an admin and a team.\nSet <code>0</code> if you want this assign to no admin or team (ie. Unassigned).</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("assignee_id")
        public _FinalStage assigneeId(@NotNull String assigneeId) {
            this.assigneeId = Objects.requireNonNull(assigneeId, "assigneeId must not be null");
            return this;
        }

        /**
         * <p>Optionally you can send a response in the conversation when it is assigned.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage body(String body) {
            this.body = Optional.ofNullable(body);
            return this;
        }

        /**
         * <p>Optionally you can send a response in the conversation when it is assigned.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "body", nulls = Nulls.SKIP)
        public _FinalStage body(Optional<String> body) {
            this.body = body;
            return this;
        }

        @java.lang.Override
        public AssignConversationRequest build() {
            return new AssignConversationRequest(type, adminId, assigneeId, body, additionalProperties);
        }
    }

    public static final class Type {
        public static final Type ADMIN = new Type(Value.ADMIN, "admin");

        public static final Type TEAM = new Type(Value.TEAM, "team");

        private final Value value;

        private final String string;

        Type(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Type && this.string.equals(((Type) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case ADMIN:
                    return visitor.visitAdmin();
                case TEAM:
                    return visitor.visitTeam();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Type valueOf(String value) {
            switch (value) {
                case "admin":
                    return ADMIN;
                case "team":
                    return TEAM;
                default:
                    return new Type(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            ADMIN,

            TEAM,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitAdmin();

            T visitTeam();

            T visitUnknown(String unknownType);
        }
    }
}
