/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.companies.types.Company;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CompanyScroll.Builder.class)
public final class CompanyScroll {
    private final List<Company> data;

    private final Optional<CursorPages> pages;

    private final Optional<Integer> totalCount;

    private final Optional<String> scrollParam;

    private final Map<String, Object> additionalProperties;

    private CompanyScroll(
            List<Company> data,
            Optional<CursorPages> pages,
            Optional<Integer> totalCount,
            Optional<String> scrollParam,
            Map<String, Object> additionalProperties) {
        this.data = data;
        this.pages = pages;
        this.totalCount = totalCount;
        this.scrollParam = scrollParam;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type of object - <code>list</code>
     */
    @JsonProperty("type")
    public String getType() {
        return "list";
    }

    @JsonProperty("data")
    public List<Company> getData() {
        return data;
    }

    @JsonProperty("pages")
    public Optional<CursorPages> getPages() {
        return pages;
    }

    /**
     * @return The total number of companies
     */
    @JsonProperty("total_count")
    public Optional<Integer> getTotalCount() {
        return totalCount;
    }

    /**
     * @return The scroll parameter to use in the next request to fetch the next page of results.
     */
    @JsonProperty("scroll_param")
    public Optional<String> getScrollParam() {
        return scrollParam;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CompanyScroll && equalTo((CompanyScroll) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyScroll other) {
        return data.equals(other.data)
                && pages.equals(other.pages)
                && totalCount.equals(other.totalCount)
                && scrollParam.equals(other.scrollParam);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.data, this.pages, this.totalCount, this.scrollParam);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private List<Company> data = new ArrayList<>();

        private Optional<CursorPages> pages = Optional.empty();

        private Optional<Integer> totalCount = Optional.empty();

        private Optional<String> scrollParam = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(CompanyScroll other) {
            data(other.getData());
            pages(other.getPages());
            totalCount(other.getTotalCount());
            scrollParam(other.getScrollParam());
            return this;
        }

        @JsonSetter(value = "data", nulls = Nulls.SKIP)
        public Builder data(List<Company> data) {
            this.data.clear();
            this.data.addAll(data);
            return this;
        }

        public Builder addData(Company data) {
            this.data.add(data);
            return this;
        }

        public Builder addAllData(List<Company> data) {
            this.data.addAll(data);
            return this;
        }

        @JsonSetter(value = "pages", nulls = Nulls.SKIP)
        public Builder pages(Optional<CursorPages> pages) {
            this.pages = pages;
            return this;
        }

        public Builder pages(CursorPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        /**
         * <p>The total number of companies</p>
         */
        @JsonSetter(value = "total_count", nulls = Nulls.SKIP)
        public Builder totalCount(Optional<Integer> totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public Builder totalCount(Integer totalCount) {
            this.totalCount = Optional.ofNullable(totalCount);
            return this;
        }

        /**
         * <p>The scroll parameter to use in the next request to fetch the next page of results.</p>
         */
        @JsonSetter(value = "scroll_param", nulls = Nulls.SKIP)
        public Builder scrollParam(Optional<String> scrollParam) {
            this.scrollParam = scrollParam;
            return this;
        }

        public Builder scrollParam(String scrollParam) {
            this.scrollParam = Optional.ofNullable(scrollParam);
            return this;
        }

        public CompanyScroll build() {
            return new CompanyScroll(data, pages, totalCount, scrollParam, additionalProperties);
        }
    }
}
