/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.Optional;

public final class Component {
    private final Value value;

    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    private Component(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return value.visit(visitor);
    }

    public static Component button(ButtonComponent value) {
        return new Component(new ButtonValue(value));
    }

    public static Component checkbox(CheckboxComponent value) {
        return new Component(new CheckboxValue(value));
    }

    public static Component dropdown(DropdownComponent value) {
        return new Component(new DropdownValue(value));
    }

    public static Component input(InputComponent value) {
        return new Component(new InputValue(value));
    }

    public static Component list(ListComponent value) {
        return new Component(new ListValue(value));
    }

    public static Component singleSelect(SingleSelectComponent value) {
        return new Component(new SingleSelectValue(value));
    }

    public static Component textarea(TextAreaComponent value) {
        return new Component(new TextareaValue(value));
    }

    public static Component dataTable(DataTableComponent value) {
        return new Component(new DataTableValue(value));
    }

    public static Component divider(DividerComponent value) {
        return new Component(new DividerValue(value));
    }

    public static Component image(ImageComponent value) {
        return new Component(new ImageValue(value));
    }

    public static Component spacer(SpacerComponent value) {
        return new Component(new SpacerValue(value));
    }

    public static Component text(TextComponent value) {
        return new Component(new TextValue(value));
    }

    public boolean isButton() {
        return value instanceof ButtonValue;
    }

    public boolean isCheckbox() {
        return value instanceof CheckboxValue;
    }

    public boolean isDropdown() {
        return value instanceof DropdownValue;
    }

    public boolean isInput() {
        return value instanceof InputValue;
    }

    public boolean isList() {
        return value instanceof ListValue;
    }

    public boolean isSingleSelect() {
        return value instanceof SingleSelectValue;
    }

    public boolean isTextarea() {
        return value instanceof TextareaValue;
    }

    public boolean isDataTable() {
        return value instanceof DataTableValue;
    }

    public boolean isDivider() {
        return value instanceof DividerValue;
    }

    public boolean isImage() {
        return value instanceof ImageValue;
    }

    public boolean isSpacer() {
        return value instanceof SpacerValue;
    }

    public boolean isText() {
        return value instanceof TextValue;
    }

    public boolean _isUnknown() {
        return value instanceof _UnknownValue;
    }

    public Optional<ButtonComponent> getButton() {
        if (isButton()) {
            return Optional.of(((ButtonValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<CheckboxComponent> getCheckbox() {
        if (isCheckbox()) {
            return Optional.of(((CheckboxValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<DropdownComponent> getDropdown() {
        if (isDropdown()) {
            return Optional.of(((DropdownValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<InputComponent> getInput() {
        if (isInput()) {
            return Optional.of(((InputValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<ListComponent> getList() {
        if (isList()) {
            return Optional.of(((ListValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<SingleSelectComponent> getSingleSelect() {
        if (isSingleSelect()) {
            return Optional.of(((SingleSelectValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<TextAreaComponent> getTextarea() {
        if (isTextarea()) {
            return Optional.of(((TextareaValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<DataTableComponent> getDataTable() {
        if (isDataTable()) {
            return Optional.of(((DataTableValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<DividerComponent> getDivider() {
        if (isDivider()) {
            return Optional.of(((DividerValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<ImageComponent> getImage() {
        if (isImage()) {
            return Optional.of(((ImageValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<SpacerComponent> getSpacer() {
        if (isSpacer()) {
            return Optional.of(((SpacerValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<TextComponent> getText() {
        if (isText()) {
            return Optional.of(((TextValue) value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (_isUnknown()) {
            return Optional.of(((_UnknownValue) value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    public interface Visitor<T> {
        T visitButton(ButtonComponent button);

        T visitCheckbox(CheckboxComponent checkbox);

        T visitDropdown(DropdownComponent dropdown);

        T visitInput(InputComponent input);

        T visitList(ListComponent list);

        T visitSingleSelect(SingleSelectComponent singleSelect);

        T visitTextarea(TextAreaComponent textarea);

        T visitDataTable(DataTableComponent dataTable);

        T visitDivider(DividerComponent divider);

        T visitImage(ImageComponent image);

        T visitSpacer(SpacerComponent spacer);

        T visitText(TextComponent text);

        T _visitUnknown(Object unknownType);
    }

    @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, property = "type", visible = true, defaultImpl = _UnknownValue.class)
    @JsonSubTypes({
        @JsonSubTypes.Type(ButtonValue.class),
        @JsonSubTypes.Type(CheckboxValue.class),
        @JsonSubTypes.Type(DropdownValue.class),
        @JsonSubTypes.Type(InputValue.class),
        @JsonSubTypes.Type(ListValue.class),
        @JsonSubTypes.Type(SingleSelectValue.class),
        @JsonSubTypes.Type(TextareaValue.class),
        @JsonSubTypes.Type(DataTableValue.class),
        @JsonSubTypes.Type(DividerValue.class),
        @JsonSubTypes.Type(ImageValue.class),
        @JsonSubTypes.Type(SpacerValue.class),
        @JsonSubTypes.Type(TextValue.class)
    })
    @JsonIgnoreProperties(ignoreUnknown = true)
    private interface Value {
        <T> T visit(Visitor<T> visitor);
    }

    @JsonTypeName("button")
    @JsonIgnoreProperties("type")
    private static final class ButtonValue implements Value {
        @JsonUnwrapped
        private ButtonComponent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private ButtonValue() {}

        private ButtonValue(ButtonComponent value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitButton(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof ButtonValue && equalTo((ButtonValue) other);
        }

        private boolean equalTo(ButtonValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "Component{" + "value: " + value + "}";
        }
    }

    @JsonTypeName("checkbox")
    @JsonIgnoreProperties("type")
    private static final class CheckboxValue implements Value {
        @JsonUnwrapped
        private CheckboxComponent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private CheckboxValue() {}

        private CheckboxValue(CheckboxComponent value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitCheckbox(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof CheckboxValue && equalTo((CheckboxValue) other);
        }

        private boolean equalTo(CheckboxValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "Component{" + "value: " + value + "}";
        }
    }

    @JsonTypeName("dropdown")
    @JsonIgnoreProperties("type")
    private static final class DropdownValue implements Value {
        @JsonUnwrapped
        private DropdownComponent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private DropdownValue() {}

        private DropdownValue(DropdownComponent value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitDropdown(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof DropdownValue && equalTo((DropdownValue) other);
        }

        private boolean equalTo(DropdownValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "Component{" + "value: " + value + "}";
        }
    }

    @JsonTypeName("input")
    @JsonIgnoreProperties("type")
    private static final class InputValue implements Value {
        @JsonUnwrapped
        private InputComponent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private InputValue() {}

        private InputValue(InputComponent value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitInput(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof InputValue && equalTo((InputValue) other);
        }

        private boolean equalTo(InputValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "Component{" + "value: " + value + "}";
        }
    }

    @JsonTypeName("list")
    @JsonIgnoreProperties("type")
    private static final class ListValue implements Value {
        @JsonUnwrapped
        private ListComponent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private ListValue() {}

        private ListValue(ListComponent value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitList(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof ListValue && equalTo((ListValue) other);
        }

        private boolean equalTo(ListValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "Component{" + "value: " + value + "}";
        }
    }

    @JsonTypeName("single-select")
    @JsonIgnoreProperties("type")
    private static final class SingleSelectValue implements Value {
        @JsonUnwrapped
        private SingleSelectComponent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private SingleSelectValue() {}

        private SingleSelectValue(SingleSelectComponent value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitSingleSelect(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof SingleSelectValue && equalTo((SingleSelectValue) other);
        }

        private boolean equalTo(SingleSelectValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "Component{" + "value: " + value + "}";
        }
    }

    @JsonTypeName("textarea")
    @JsonIgnoreProperties("type")
    private static final class TextareaValue implements Value {
        @JsonUnwrapped
        private TextAreaComponent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private TextareaValue() {}

        private TextareaValue(TextAreaComponent value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitTextarea(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof TextareaValue && equalTo((TextareaValue) other);
        }

        private boolean equalTo(TextareaValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "Component{" + "value: " + value + "}";
        }
    }

    @JsonTypeName("data-table")
    @JsonIgnoreProperties("type")
    private static final class DataTableValue implements Value {
        @JsonUnwrapped
        private DataTableComponent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private DataTableValue() {}

        private DataTableValue(DataTableComponent value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitDataTable(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof DataTableValue && equalTo((DataTableValue) other);
        }

        private boolean equalTo(DataTableValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "Component{" + "value: " + value + "}";
        }
    }

    @JsonTypeName("divider")
    @JsonIgnoreProperties("type")
    private static final class DividerValue implements Value {
        @JsonUnwrapped
        private DividerComponent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private DividerValue() {}

        private DividerValue(DividerComponent value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitDivider(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof DividerValue && equalTo((DividerValue) other);
        }

        private boolean equalTo(DividerValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "Component{" + "value: " + value + "}";
        }
    }

    @JsonTypeName("image")
    @JsonIgnoreProperties("type")
    private static final class ImageValue implements Value {
        @JsonUnwrapped
        private ImageComponent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private ImageValue() {}

        private ImageValue(ImageComponent value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitImage(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof ImageValue && equalTo((ImageValue) other);
        }

        private boolean equalTo(ImageValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "Component{" + "value: " + value + "}";
        }
    }

    @JsonTypeName("spacer")
    @JsonIgnoreProperties("type")
    private static final class SpacerValue implements Value {
        @JsonUnwrapped
        private SpacerComponent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private SpacerValue() {}

        private SpacerValue(SpacerComponent value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitSpacer(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof SpacerValue && equalTo((SpacerValue) other);
        }

        private boolean equalTo(SpacerValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "Component{" + "value: " + value + "}";
        }
    }

    @JsonTypeName("text")
    @JsonIgnoreProperties("type")
    private static final class TextValue implements Value {
        @JsonUnwrapped
        private TextComponent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private TextValue() {}

        private TextValue(TextComponent value) {
            this.value = value;
        }

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitText(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof TextValue && equalTo((TextValue) other);
        }

        private boolean equalTo(TextValue other) {
            return value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @java.lang.Override
        public String toString() {
            return "Component{" + "value: " + value + "}";
        }
    }

    @JsonIgnoreProperties("type")
    private static final class _UnknownValue implements Value {
        private String type;

        @JsonValue
        private Object value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty("value") Object value) {}

        @java.lang.Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(value);
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof _UnknownValue && equalTo((_UnknownValue) other);
        }

        private boolean equalTo(_UnknownValue other) {
            return type.equals(other.type) && value.equals(other.value);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        @java.lang.Override
        public String toString() {
            return "Component{" + "type: " + type + ", value: " + value + "}";
        }
    }
}
