/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ContactArchived.Builder.class)
public final class ContactArchived {
    private final String id;

    private final Optional<String> externalId;

    private final boolean archived;

    private final Map<String, Object> additionalProperties;

    private ContactArchived(
            String id, Optional<String> externalId, boolean archived, Map<String, Object> additionalProperties) {
        this.id = id;
        this.externalId = externalId;
        this.archived = archived;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return always contact
     */
    @JsonProperty("type")
    public String getType() {
        return "contact";
    }

    /**
     * @return The unique identifier for the contact which is given by Intercom.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The unique identifier for the contact which is provided by the Client.
     */
    @JsonProperty("external_id")
    public Optional<String> getExternalId() {
        return externalId;
    }

    /**
     * @return Whether the contact is archived or not.
     */
    @JsonProperty("archived")
    public boolean getArchived() {
        return archived;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ContactArchived && equalTo((ContactArchived) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContactArchived other) {
        return id.equals(other.id) && externalId.equals(other.externalId) && archived == other.archived;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.externalId, this.archived);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The unique identifier for the contact which is given by Intercom.
         */
        ArchivedStage id(@NotNull String id);

        Builder from(ContactArchived other);
    }

    public interface ArchivedStage {
        /**
         * Whether the contact is archived or not.
         */
        _FinalStage archived(boolean archived);
    }

    public interface _FinalStage {
        ContactArchived build();

        /**
         * <p>The unique identifier for the contact which is provided by the Client.</p>
         */
        _FinalStage externalId(Optional<String> externalId);

        _FinalStage externalId(String externalId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, ArchivedStage, _FinalStage {
        private String id;

        private boolean archived;

        private Optional<String> externalId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ContactArchived other) {
            id(other.getId());
            externalId(other.getExternalId());
            archived(other.getArchived());
            return this;
        }

        /**
         * The unique identifier for the contact which is given by Intercom.<p>The unique identifier for the contact which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public ArchivedStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * Whether the contact is archived or not.<p>Whether the contact is archived or not.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("archived")
        public _FinalStage archived(boolean archived) {
            this.archived = archived;
            return this;
        }

        /**
         * <p>The unique identifier for the contact which is provided by the Client.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage externalId(String externalId) {
            this.externalId = Optional.ofNullable(externalId);
            return this;
        }

        /**
         * <p>The unique identifier for the contact which is provided by the Client.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "external_id", nulls = Nulls.SKIP)
        public _FinalStage externalId(Optional<String> externalId) {
            this.externalId = externalId;
            return this;
        }

        @java.lang.Override
        public ContactArchived build() {
            return new ContactArchived(id, externalId, archived, additionalProperties);
        }
    }
}
