/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ContentObject.Builder.class)
public final class ContentObject {
    private final List<Component> components;

    private final Map<String, Object> additionalProperties;

    private ContentObject(List<Component> components, Map<String, Object> additionalProperties) {
        this.components = components;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The list of components to be rendered.
     */
    @JsonProperty("components")
    public List<Component> getComponents() {
        return components;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ContentObject && equalTo((ContentObject) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ContentObject other) {
        return components.equals(other.components);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.components);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private List<Component> components = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ContentObject other) {
            components(other.getComponents());
            return this;
        }

        /**
         * <p>The list of components to be rendered.</p>
         */
        @JsonSetter(value = "components", nulls = Nulls.SKIP)
        public Builder components(List<Component> components) {
            this.components.clear();
            this.components.addAll(components);
            return this;
        }

        public Builder addComponents(Component components) {
            this.components.add(components);
            return this;
        }

        public Builder addAllComponents(List<Component> components) {
            this.components.addAll(components);
            return this;
        }

        public ContentObject build() {
            return new ContentObject(components, additionalProperties);
        }
    }
}
