/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConversationFirstContactReply.Builder.class)
public final class ConversationFirstContactReply {
    private final int createdAt;

    private final String type;

    private final Optional<String> url;

    private final Map<String, Object> additionalProperties;

    private ConversationFirstContactReply(
            int createdAt, String type, Optional<String> url, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.type = type;
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return
     */
    @JsonProperty("created_at")
    public int getCreatedAt() {
        return createdAt;
    }

    /**
     * @return
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * @return
     */
    @JsonProperty("url")
    public Optional<String> getUrl() {
        return url;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConversationFirstContactReply && equalTo((ConversationFirstContactReply) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConversationFirstContactReply other) {
        return createdAt == other.createdAt && type.equals(other.type) && url.equals(other.url);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.createdAt, this.type, this.url);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    public interface CreatedAtStage {
        TypeStage createdAt(int createdAt);

        Builder from(ConversationFirstContactReply other);
    }

    public interface TypeStage {
        _FinalStage type(@NotNull String type);
    }

    public interface _FinalStage {
        ConversationFirstContactReply build();

        _FinalStage url(Optional<String> url);

        _FinalStage url(String url);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements CreatedAtStage, TypeStage, _FinalStage {
        private int createdAt;

        private String type;

        private Optional<String> url = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ConversationFirstContactReply other) {
            createdAt(other.getCreatedAt());
            type(other.getType());
            url(other.getUrl());
            return this;
        }

        /**
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at")
        public TypeStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("type")
        public _FinalStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        /**
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage url(String url) {
            this.url = Optional.ofNullable(url);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "url", nulls = Nulls.SKIP)
        public _FinalStage url(Optional<String> url) {
            this.url = url;
            return this;
        }

        @java.lang.Override
        public ConversationFirstContactReply build() {
            return new ConversationFirstContactReply(createdAt, type, url, additionalProperties);
        }
    }
}
