/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DataEventSummaryItem.Builder.class)
public final class DataEventSummaryItem {
    private final String name;

    private final String first;

    private final String last;

    private final int count;

    private final Optional<String> description;

    private final Map<String, Object> additionalProperties;

    private DataEventSummaryItem(
            String name,
            String first,
            String last,
            int count,
            Optional<String> description,
            Map<String, Object> additionalProperties) {
        this.name = name;
        this.first = first;
        this.last = last;
        this.count = count;
        this.description = description;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The name of the event
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return The first time the event was sent
     */
    @JsonProperty("first")
    public String getFirst() {
        return first;
    }

    /**
     * @return The last time the event was sent
     */
    @JsonProperty("last")
    public String getLast() {
        return last;
    }

    /**
     * @return The number of times the event was sent
     */
    @JsonProperty("count")
    public int getCount() {
        return count;
    }

    /**
     * @return The description of the event
     */
    @JsonProperty("description")
    public Optional<String> getDescription() {
        return description;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DataEventSummaryItem && equalTo((DataEventSummaryItem) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataEventSummaryItem other) {
        return name.equals(other.name)
                && first.equals(other.first)
                && last.equals(other.last)
                && count == other.count
                && description.equals(other.description);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.name, this.first, this.last, this.count, this.description);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    public interface NameStage {
        /**
         * The name of the event
         */
        FirstStage name(@NotNull String name);

        Builder from(DataEventSummaryItem other);
    }

    public interface FirstStage {
        /**
         * The first time the event was sent
         */
        LastStage first(@NotNull String first);
    }

    public interface LastStage {
        /**
         * The last time the event was sent
         */
        CountStage last(@NotNull String last);
    }

    public interface CountStage {
        /**
         * The number of times the event was sent
         */
        _FinalStage count(int count);
    }

    public interface _FinalStage {
        DataEventSummaryItem build();

        /**
         * <p>The description of the event</p>
         */
        _FinalStage description(Optional<String> description);

        _FinalStage description(String description);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements NameStage, FirstStage, LastStage, CountStage, _FinalStage {
        private String name;

        private String first;

        private String last;

        private int count;

        private Optional<String> description = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(DataEventSummaryItem other) {
            name(other.getName());
            first(other.getFirst());
            last(other.getLast());
            count(other.getCount());
            description(other.getDescription());
            return this;
        }

        /**
         * The name of the event<p>The name of the event</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public FirstStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * The first time the event was sent<p>The first time the event was sent</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("first")
        public LastStage first(@NotNull String first) {
            this.first = Objects.requireNonNull(first, "first must not be null");
            return this;
        }

        /**
         * The last time the event was sent<p>The last time the event was sent</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("last")
        public CountStage last(@NotNull String last) {
            this.last = Objects.requireNonNull(last, "last must not be null");
            return this;
        }

        /**
         * The number of times the event was sent<p>The number of times the event was sent</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("count")
        public _FinalStage count(int count) {
            this.count = count;
            return this;
        }

        /**
         * <p>The description of the event</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        /**
         * <p>The description of the event</p>
         */
        @java.lang.Override
        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @java.lang.Override
        public DataEventSummaryItem build() {
            return new DataEventSummaryItem(name, first, last, count, description, additionalProperties);
        }
    }
}
