/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = DataTableComponent.Builder.class)
public final class DataTableComponent {
    private final List<DataTableItem> items;

    private final Map<String, Object> additionalProperties;

    private DataTableComponent(List<DataTableItem> items, Map<String, Object> additionalProperties) {
        this.items = items;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The items that will be rendered in the data-table.
     */
    @JsonProperty("items")
    public List<DataTableItem> getItems() {
        return items;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof DataTableComponent && equalTo((DataTableComponent) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DataTableComponent other) {
        return items.equals(other.items);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.items);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private List<DataTableItem> items = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(DataTableComponent other) {
            items(other.getItems());
            return this;
        }

        /**
         * <p>The items that will be rendered in the data-table.</p>
         */
        @JsonSetter(value = "items", nulls = Nulls.SKIP)
        public Builder items(List<DataTableItem> items) {
            this.items.clear();
            this.items.addAll(items);
            return this;
        }

        public Builder addItems(DataTableItem items) {
            this.items.add(items);
            return this;
        }

        public Builder addAllItems(List<DataTableItem> items) {
            this.items.addAll(items);
            return this;
        }

        public DataTableComponent build() {
            return new DataTableComponent(items, additionalProperties);
        }
    }
}
