/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Error.Builder.class)
public final class Error {
    private final Optional<String> requestId;

    private final List<ErrorsItem> errors;

    private final Map<String, Object> additionalProperties;

    private Error(Optional<String> requestId, List<ErrorsItem> errors, Map<String, Object> additionalProperties) {
        this.requestId = requestId;
        this.errors = errors;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The type is error.list
     */
    @JsonProperty("type")
    public String getType() {
        return "error.list";
    }

    /**
     * @return
     */
    @JsonProperty("request_id")
    public Optional<String> getRequestId() {
        return requestId;
    }

    /**
     * @return An array of one or more error objects
     */
    @JsonProperty("errors")
    public List<ErrorsItem> getErrors() {
        return errors;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Error && equalTo((Error) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Error other) {
        return requestId.equals(other.requestId) && errors.equals(other.errors);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.requestId, this.errors);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> requestId = Optional.empty();

        private List<ErrorsItem> errors = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(Error other) {
            requestId(other.getRequestId());
            errors(other.getErrors());
            return this;
        }

        @JsonSetter(value = "request_id", nulls = Nulls.SKIP)
        public Builder requestId(Optional<String> requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder requestId(String requestId) {
            this.requestId = Optional.ofNullable(requestId);
            return this;
        }

        /**
         * <p>An array of one or more error objects</p>
         */
        @JsonSetter(value = "errors", nulls = Nulls.SKIP)
        public Builder errors(List<ErrorsItem> errors) {
            this.errors.clear();
            this.errors.addAll(errors);
            return this;
        }

        public Builder addErrors(ErrorsItem errors) {
            this.errors.add(errors);
            return this;
        }

        public Builder addAllErrors(List<ErrorsItem> errors) {
            this.errors.addAll(errors);
            return this;
        }

        public Error build() {
            return new Error(requestId, errors, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = ErrorsItem.Builder.class)
    public static final class ErrorsItem {
        private final String code;

        private final Optional<String> message;

        private final Optional<String> field;

        private final Map<String, Object> additionalProperties;

        private ErrorsItem(
                String code,
                Optional<String> message,
                Optional<String> field,
                Map<String, Object> additionalProperties) {
            this.code = code;
            this.message = message;
            this.field = field;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return A string indicating the kind of error, used to further qualify the HTTP response code
         */
        @JsonProperty("code")
        public String getCode() {
            return code;
        }

        /**
         * @return Optional. Human readable description of the error.
         */
        @JsonProperty("message")
        public Optional<String> getMessage() {
            return message;
        }

        /**
         * @return Optional. Used to identify a particular field or query parameter that was in error.
         */
        @JsonProperty("field")
        public Optional<String> getField() {
            return field;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof ErrorsItem && equalTo((ErrorsItem) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(ErrorsItem other) {
            return code.equals(other.code) && message.equals(other.message) && field.equals(other.field);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.code, this.message, this.field);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static CodeStage builder() {
            return new Builder();
        }

        public interface CodeStage {
            /**
             * A string indicating the kind of error, used to further qualify the HTTP response code
             */
            _FinalStage code(@NotNull String code);

            Builder from(ErrorsItem other);
        }

        public interface _FinalStage {
            ErrorsItem build();

            /**
             * <p>Optional. Human readable description of the error.</p>
             */
            _FinalStage message(Optional<String> message);

            _FinalStage message(String message);

            /**
             * <p>Optional. Used to identify a particular field or query parameter that was in error.</p>
             */
            _FinalStage field(Optional<String> field);

            _FinalStage field(String field);
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder implements CodeStage, _FinalStage {
            private String code;

            private Optional<String> field = Optional.empty();

            private Optional<String> message = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            @java.lang.Override
            public Builder from(ErrorsItem other) {
                code(other.getCode());
                message(other.getMessage());
                field(other.getField());
                return this;
            }

            /**
             * A string indicating the kind of error, used to further qualify the HTTP response code<p>A string indicating the kind of error, used to further qualify the HTTP response code</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            @JsonSetter("code")
            public _FinalStage code(@NotNull String code) {
                this.code = Objects.requireNonNull(code, "code must not be null");
                return this;
            }

            /**
             * <p>Optional. Used to identify a particular field or query parameter that was in error.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage field(String field) {
                this.field = Optional.ofNullable(field);
                return this;
            }

            /**
             * <p>Optional. Used to identify a particular field or query parameter that was in error.</p>
             */
            @java.lang.Override
            @JsonSetter(value = "field", nulls = Nulls.SKIP)
            public _FinalStage field(Optional<String> field) {
                this.field = field;
                return this;
            }

            /**
             * <p>Optional. Human readable description of the error.</p>
             * @return Reference to {@code this} so that method calls can be chained together.
             */
            @java.lang.Override
            public _FinalStage message(String message) {
                this.message = Optional.ofNullable(message);
                return this;
            }

            /**
             * <p>Optional. Human readable description of the error.</p>
             */
            @java.lang.Override
            @JsonSetter(value = "message", nulls = Nulls.SKIP)
            public _FinalStage message(Optional<String> message) {
                this.message = message;
                return this;
            }

            @java.lang.Override
            public ErrorsItem build() {
                return new ErrorsItem(code, message, field, additionalProperties);
            }
        }
    }
}
