/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = LiveCanvasResponse.Builder.class)
public final class LiveCanvasResponse {
    private final ContentObject content;

    private final Map<String, Object> additionalProperties;

    private LiveCanvasResponse(ContentObject content, Map<String, Object> additionalProperties) {
        this.content = content;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The content object that defines the components to be shown.
     */
    @JsonProperty("content")
    public ContentObject getContent() {
        return content;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof LiveCanvasResponse && equalTo((LiveCanvasResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(LiveCanvasResponse other) {
        return content.equals(other.content);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.content);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ContentStage builder() {
        return new Builder();
    }

    public interface ContentStage {
        /**
         * The content object that defines the components to be shown.
         */
        _FinalStage content(@NotNull ContentObject content);

        Builder from(LiveCanvasResponse other);
    }

    public interface _FinalStage {
        LiveCanvasResponse build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ContentStage, _FinalStage {
        private ContentObject content;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(LiveCanvasResponse other) {
            content(other.getContent());
            return this;
        }

        /**
         * The content object that defines the components to be shown.<p>The content object that defines the components to be shown.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("content")
        public _FinalStage content(@NotNull ContentObject content) {
            this.content = Objects.requireNonNull(content, "content must not be null");
            return this;
        }

        @java.lang.Override
        public LiveCanvasResponse build() {
            return new LiveCanvasResponse(content, additionalProperties);
        }
    }
}
