/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PagesLink.Builder.class)
public final class PagesLink {
    private final int page;

    private final Optional<String> next;

    private final int perPage;

    private final int totalPages;

    private final Map<String, Object> additionalProperties;

    private PagesLink(
            int page, Optional<String> next, int perPage, int totalPages, Map<String, Object> additionalProperties) {
        this.page = page;
        this.next = next;
        this.perPage = perPage;
        this.totalPages = totalPages;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("type")
    public String getType() {
        return "pages";
    }

    @JsonProperty("page")
    public int getPage() {
        return page;
    }

    /**
     * @return A link to the next page of results. A response that does not contain a next link does not have further data to fetch.
     */
    @JsonProperty("next")
    public Optional<String> getNext() {
        return next;
    }

    @JsonProperty("per_page")
    public int getPerPage() {
        return perPage;
    }

    @JsonProperty("total_pages")
    public int getTotalPages() {
        return totalPages;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PagesLink && equalTo((PagesLink) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PagesLink other) {
        return page == other.page
                && next.equals(other.next)
                && perPage == other.perPage
                && totalPages == other.totalPages;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.page, this.next, this.perPage, this.totalPages);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PageStage builder() {
        return new Builder();
    }

    public interface PageStage {
        PerPageStage page(int page);

        Builder from(PagesLink other);
    }

    public interface PerPageStage {
        TotalPagesStage perPage(int perPage);
    }

    public interface TotalPagesStage {
        _FinalStage totalPages(int totalPages);
    }

    public interface _FinalStage {
        PagesLink build();

        /**
         * <p>A link to the next page of results. A response that does not contain a next link does not have further data to fetch.</p>
         */
        _FinalStage next(Optional<String> next);

        _FinalStage next(String next);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements PageStage, PerPageStage, TotalPagesStage, _FinalStage {
        private int page;

        private int perPage;

        private int totalPages;

        private Optional<String> next = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PagesLink other) {
            page(other.getPage());
            next(other.getNext());
            perPage(other.getPerPage());
            totalPages(other.getTotalPages());
            return this;
        }

        @java.lang.Override
        @JsonSetter("page")
        public PerPageStage page(int page) {
            this.page = page;
            return this;
        }

        @java.lang.Override
        @JsonSetter("per_page")
        public TotalPagesStage perPage(int perPage) {
            this.perPage = perPage;
            return this;
        }

        @java.lang.Override
        @JsonSetter("total_pages")
        public _FinalStage totalPages(int totalPages) {
            this.totalPages = totalPages;
            return this;
        }

        /**
         * <p>A link to the next page of results. A response that does not contain a next link does not have further data to fetch.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage next(String next) {
            this.next = Optional.ofNullable(next);
            return this;
        }

        /**
         * <p>A link to the next page of results. A response that does not contain a next link does not have further data to fetch.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "next", nulls = Nulls.SKIP)
        public _FinalStage next(Optional<String> next) {
            this.next = next;
            return this;
        }

        @java.lang.Override
        public PagesLink build() {
            return new PagesLink(page, next, perPage, totalPages, additionalProperties);
        }
    }
}
