/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.conversations.types.Conversation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PaginatedConversationResponse.Builder.class)
public final class PaginatedConversationResponse {
    private final List<Conversation> conversations;

    private final int totalCount;

    private final Optional<CursorPages> pages;

    private final Map<String, Object> additionalProperties;

    private PaginatedConversationResponse(
            List<Conversation> conversations,
            int totalCount,
            Optional<CursorPages> pages,
            Map<String, Object> additionalProperties) {
        this.conversations = conversations;
        this.totalCount = totalCount;
        this.pages = pages;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Always conversation.list
     */
    @JsonProperty("type")
    public String getType() {
        return "conversation.list";
    }

    /**
     * @return The list of conversation objects
     */
    @JsonProperty("conversations")
    public List<Conversation> getConversations() {
        return conversations;
    }

    /**
     * @return A count of the total number of objects.
     */
    @JsonProperty("total_count")
    public int getTotalCount() {
        return totalCount;
    }

    @JsonProperty("pages")
    public Optional<CursorPages> getPages() {
        return pages;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PaginatedConversationResponse && equalTo((PaginatedConversationResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PaginatedConversationResponse other) {
        return conversations.equals(other.conversations) && totalCount == other.totalCount && pages.equals(other.pages);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.conversations, this.totalCount, this.pages);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TotalCountStage builder() {
        return new Builder();
    }

    public interface TotalCountStage {
        /**
         * A count of the total number of objects.
         */
        _FinalStage totalCount(int totalCount);

        Builder from(PaginatedConversationResponse other);
    }

    public interface _FinalStage {
        PaginatedConversationResponse build();

        /**
         * <p>The list of conversation objects</p>
         */
        _FinalStage conversations(List<Conversation> conversations);

        _FinalStage addConversations(Conversation conversations);

        _FinalStage addAllConversations(List<Conversation> conversations);

        _FinalStage pages(Optional<CursorPages> pages);

        _FinalStage pages(CursorPages pages);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TotalCountStage, _FinalStage {
        private int totalCount;

        private Optional<CursorPages> pages = Optional.empty();

        private List<Conversation> conversations = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PaginatedConversationResponse other) {
            conversations(other.getConversations());
            totalCount(other.getTotalCount());
            pages(other.getPages());
            return this;
        }

        /**
         * A count of the total number of objects.<p>A count of the total number of objects.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("total_count")
        public _FinalStage totalCount(int totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        @java.lang.Override
        public _FinalStage pages(CursorPages pages) {
            this.pages = Optional.ofNullable(pages);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "pages", nulls = Nulls.SKIP)
        public _FinalStage pages(Optional<CursorPages> pages) {
            this.pages = pages;
            return this;
        }

        /**
         * <p>The list of conversation objects</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllConversations(List<Conversation> conversations) {
            this.conversations.addAll(conversations);
            return this;
        }

        /**
         * <p>The list of conversation objects</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addConversations(Conversation conversations) {
            this.conversations.add(conversations);
            return this;
        }

        /**
         * <p>The list of conversation objects</p>
         */
        @java.lang.Override
        @JsonSetter(value = "conversations", nulls = Nulls.SKIP)
        public _FinalStage conversations(List<Conversation> conversations) {
            this.conversations.clear();
            this.conversations.addAll(conversations);
            return this;
        }

        @java.lang.Override
        public PaginatedConversationResponse build() {
            return new PaginatedConversationResponse(conversations, totalCount, pages, additionalProperties);
        }
    }
}
